@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings concerning the virtual network.
 * @property id Uri of the virtual network.
 * @property subnet Properties of a subnet.
 */
public data class VirtualNetworkPropertiesResponse(
    public val id: String? = null,
    public val subnet: SubnetPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.powerplatform.outputs.VirtualNetworkPropertiesResponse):
            VirtualNetworkPropertiesResponse = VirtualNetworkPropertiesResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.powerplatform.kotlin.outputs.SubnetPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
