@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.professionalservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * professionalService properties
 * @property autoRenew Whether the ProfessionalService subscription will auto renew upon term end.
 * @property billingPeriod The billing period eg P1M,P1Y for monthly,yearly respectively
 * @property created The created date of this resource.
 * @property isFreeTrial Whether the current term is a Free Trial term
 * @property lastModified The last modifier date if this resource.
 * @property offerId The offer id.
 * @property paymentChannelMetadata The metadata about the ProfessionalService subscription such as the AzureSubscriptionId and ResourceUri.
 * @property paymentChannelType The Payment channel for the ProfessionalServiceSubscription.
 * @property publisherId The publisher id.
 * @property quoteId The quote id which the ProfessionalService will be purchase with.
 * @property skuId The plan id.
 * @property status The ProfessionalService Subscription Status.
 * @property storeFront The store front which initiates the purchase.
 * @property term The current Term object.
 * @property termUnit The unit term eg P1M,P1Y,P2Y,P3Y meaning month,1year,2year,3year respectively
 */
public data class ProfessionalServiceResourceResponseProperties(
    public val autoRenew: Boolean? = null,
    public val billingPeriod: String? = null,
    public val created: String,
    public val isFreeTrial: Boolean? = null,
    public val lastModified: String? = null,
    public val offerId: String? = null,
    public val paymentChannelMetadata: Map<String, String>? = null,
    public val paymentChannelType: String? = null,
    public val publisherId: String? = null,
    public val quoteId: String? = null,
    public val skuId: String? = null,
    public val status: String? = null,
    public val storeFront: String? = null,
    public val term: ProfessionalServicePropertiesResponseTerm? = null,
    public val termUnit: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.professionalservice.outputs.ProfessionalServiceResourceResponseProperties):
            ProfessionalServiceResourceResponseProperties =
            ProfessionalServiceResourceResponseProperties(
                autoRenew = javaType.autoRenew().map({ args0 -> args0 }).orElse(null),
                billingPeriod = javaType.billingPeriod().map({ args0 -> args0 }).orElse(null),
                created = javaType.created(),
                isFreeTrial = javaType.isFreeTrial().map({ args0 -> args0 }).orElse(null),
                lastModified = javaType.lastModified().map({ args0 -> args0 }).orElse(null),
                offerId = javaType.offerId().map({ args0 -> args0 }).orElse(null),
                paymentChannelMetadata = javaType.paymentChannelMetadata().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                paymentChannelType = javaType.paymentChannelType().map({ args0 -> args0 }).orElse(null),
                publisherId = javaType.publisherId().map({ args0 -> args0 }).orElse(null),
                quoteId = javaType.quoteId().map({ args0 -> args0 }).orElse(null),
                skuId = javaType.skuId().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                storeFront = javaType.storeFront().map({ args0 -> args0 }).orElse(null),
                term = javaType.term().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.professionalservice.kotlin.outputs.ProfessionalServicePropertiesResponseTerm.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                termUnit = javaType.termUnit().map({ args0 -> args0 }).orElse(null),
            )
    }
}
