@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutResponseProperties
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutResponseProperties.Companion.toKotlin as defaultRolloutResponsePropertiesToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DefaultRollout].
 */
@PulumiTagMarker
public class DefaultRolloutResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultRolloutArgs = DefaultRolloutArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultRolloutArgsBuilder.() -> Unit) {
        val builder = DefaultRolloutArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DefaultRollout {
        val builtJavaResource =
            com.pulumi.azurenative.providerhub.DefaultRollout(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DefaultRollout(builtJavaResource)
    }
}

/**
 * Default rollout definition.
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### DefaultRollouts_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultRollout = new AzureNative.ProviderHub.DefaultRollout("defaultRollout", new()
 *     {
 *         Properties = new AzureNative.ProviderHub.Inputs.DefaultRolloutPropertiesArgs
 *         {
 *             Specification = new AzureNative.ProviderHub.Inputs.DefaultRolloutPropertiesSpecificationArgs
 *             {
 *                 Canary = new AzureNative.ProviderHub.Inputs.DefaultRolloutSpecificationCanaryArgs
 *                 {
 *                     SkipRegions = new[]
 *                     {
 *                         "eastus2euap",
 *                     },
 *                 },
 *                 ExpeditedRollout = new AzureNative.ProviderHub.Inputs.DefaultRolloutSpecificationExpeditedRolloutArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *                 RestOfTheWorldGroupTwo = new AzureNative.ProviderHub.Inputs.DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs
 *                 {
 *                     WaitDuration = "PT4H",
 *                 },
 *             },
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *         RolloutName = "2020week10",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := providerhub.NewDefaultRollout(ctx, "defaultRollout", &providerhub.DefaultRolloutArgs{
 * Properties: providerhub.DefaultRolloutResponseProperties{
 * Specification: interface{}{
 * Canary: &providerhub.DefaultRolloutSpecificationCanaryArgs{
 * SkipRegions: pulumi.StringArray{
 * pulumi.String("eastus2euap"),
 * },
 * },
 * ExpeditedRollout: &providerhub.DefaultRolloutSpecificationExpeditedRolloutArgs{
 * Enabled: pulumi.Bool(true),
 * },
 * RestOfTheWorldGroupTwo: &providerhub.DefaultRolloutSpecificationRestOfTheWorldGroupTwoArgs{
 * WaitDuration: pulumi.String("PT4H"),
 * },
 * },
 * },
 * ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * RolloutName: pulumi.String("2020week10"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.DefaultRollout;
 * import com.pulumi.azurenative.providerhub.DefaultRolloutArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultRollout = new DefaultRollout("defaultRollout", DefaultRolloutArgs.builder()
 *             .properties(Map.of("specification", Map.ofEntries(
 *                 Map.entry("canary", Map.of("skipRegions", "eastus2euap")),
 *                 Map.entry("expeditedRollout", Map.of("enabled", true)),
 *                 Map.entry("restOfTheWorldGroupTwo", Map.of("waitDuration", "PT4H"))
 *             )))
 *             .providerNamespace("Microsoft.Contoso")
 *             .rolloutName("2020week10")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:DefaultRollout Microsoft.Contoso/2020week10 /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/defaultRollouts/{rolloutName}
 * ```
 */
public class DefaultRollout internal constructor(
    override val javaResource: com.pulumi.azurenative.providerhub.DefaultRollout,
) : KotlinCustomResource(javaResource, DefaultRolloutMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the rollout.
     */
    public val properties: Output<DefaultRolloutResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                defaultRolloutResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DefaultRolloutMapper : ResourceMapper<DefaultRollout> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.providerhub.DefaultRollout::class == javaResource::class

    override fun map(javaResource: Resource): DefaultRollout = DefaultRollout(
        javaResource as
            com.pulumi.azurenative.providerhub.DefaultRollout,
    )
}

/**
 * @see [DefaultRollout].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultRollout].
 */
public suspend fun defaultRollout(
    name: String,
    block: suspend DefaultRolloutResourceBuilder.() -> Unit,
): DefaultRollout {
    val builder = DefaultRolloutResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultRollout].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultRollout(name: String): DefaultRollout {
    val builder = DefaultRolloutResourceBuilder()
    builder.name(name)
    return builder.build()
}
