@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeFirstArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.inputs.SkuResourcePropertiesArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.SkuResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### Skus_CreateOrUpdateNestedResourceTypeFirst
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var skusNestedResourceTypeFirst = new AzureNative.ProviderHub.SkusNestedResourceTypeFirst("skusNestedResourceTypeFirst", new()
 *     {
 *         NestedResourceTypeFirst = "nestedResourceTypeFirst",
 *         Properties = new AzureNative.ProviderHub.Inputs.SkuResourcePropertiesArgs
 *         {
 *             SkuSettings = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.SkuSettingArgs
 *                 {
 *                     Kind = "Standard",
 *                     Name = "freeSku",
 *                     Tier = "Tier1",
 *                 },
 *                 new AzureNative.ProviderHub.Inputs.SkuSettingArgs
 *                 {
 *                     Costs = new[]
 *                     {
 *                         new AzureNative.ProviderHub.Inputs.SkuCostArgs
 *                         {
 *                             MeterId = "xxx",
 *                         },
 *                     },
 *                     Kind = "Premium",
 *                     Name = "premiumSku",
 *                     Tier = "Tier2",
 *                 },
 *             },
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *         ResourceType = "testResourceType",
 *         Sku = "testSku",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := providerhub.NewSkusNestedResourceTypeFirst(ctx, "skusNestedResourceTypeFirst", &providerhub.SkusNestedResourceTypeFirstArgs{
 * NestedResourceTypeFirst: pulumi.String("nestedResourceTypeFirst"),
 * Properties: providerhub.SkuResourceResponseProperties{
 * SkuSettings: providerhub.SkuSettingArray{
 * &providerhub.SkuSettingArgs{
 * Kind: pulumi.String("Standard"),
 * Name: pulumi.String("freeSku"),
 * Tier: pulumi.String("Tier1"),
 * },
 * interface{}{
 * Costs: providerhub.SkuCostArray{
 * &providerhub.SkuCostArgs{
 * MeterId: pulumi.String("xxx"),
 * },
 * },
 * Kind: pulumi.String("Premium"),
 * Name: pulumi.String("premiumSku"),
 * Tier: pulumi.String("Tier2"),
 * },
 * },
 * },
 * ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * ResourceType: pulumi.String("testResourceType"),
 * Sku: pulumi.String("testSku"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeFirst;
 * import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeFirstArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var skusNestedResourceTypeFirst = new SkusNestedResourceTypeFirst("skusNestedResourceTypeFirst", SkusNestedResourceTypeFirstArgs.builder()
 *             .nestedResourceTypeFirst("nestedResourceTypeFirst")
 *             .properties(Map.of("skuSettings",
 *                 Map.ofEntries(
 *                     Map.entry("kind", "Standard"),
 *                     Map.entry("name", "freeSku"),
 *                     Map.entry("tier", "Tier1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("costs", Map.of("meterId", "xxx")),
 *                     Map.entry("kind", "Premium"),
 *                     Map.entry("name", "premiumSku"),
 *                     Map.entry("tier", "Tier2")
 *                 )))
 *             .providerNamespace("Microsoft.Contoso")
 *             .resourceType("testResourceType")
 *             .sku("testSku")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:SkusNestedResourceTypeFirst Microsoft.Contoso/ /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}
 * ```
 * @property nestedResourceTypeFirst The first child resource type.
 * @property properties
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property resourceType The resource type.
 * @property sku The SKU.
 */
public data class SkusNestedResourceTypeFirstArgs(
    public val nestedResourceTypeFirst: Output<String>? = null,
    public val properties: Output<SkuResourcePropertiesArgs>? = null,
    public val providerNamespace: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val sku: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.SkusNestedResourceTypeFirstArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.SkusNestedResourceTypeFirstArgs =
        com.pulumi.azurenative.providerhub.SkusNestedResourceTypeFirstArgs.builder()
            .nestedResourceTypeFirst(nestedResourceTypeFirst?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerNamespace(providerNamespace?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkusNestedResourceTypeFirstArgs].
 */
@PulumiTagMarker
public class SkusNestedResourceTypeFirstArgsBuilder internal constructor() {
    private var nestedResourceTypeFirst: Output<String>? = null

    private var properties: Output<SkuResourcePropertiesArgs>? = null

    private var providerNamespace: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var sku: Output<String>? = null

    /**
     * @param value The first child resource type.
     */
    @JvmName("kinmpxyxkoxgcheb")
    public suspend fun nestedResourceTypeFirst(`value`: Output<String>) {
        this.nestedResourceTypeFirst = value
    }

    /**
     * @param value
     */
    @JvmName("okxkuhkdqtkeeohs")
    public suspend fun properties(`value`: Output<SkuResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("egpdlwcfghlrdfnu")
    public suspend fun providerNamespace(`value`: Output<String>) {
        this.providerNamespace = value
    }

    /**
     * @param value The resource type.
     */
    @JvmName("apiclsbdrikfdnkv")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The SKU.
     */
    @JvmName("kegutpjjkahekycx")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value The first child resource type.
     */
    @JvmName("bvvqeetmwkpbyclc")
    public suspend fun nestedResourceTypeFirst(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nestedResourceTypeFirst = mapped
    }

    /**
     * @param value
     */
    @JvmName("wylgfsilbjcnctoj")
    public suspend fun properties(`value`: SkuResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vnxfwjneevujadxh")
    public suspend fun properties(argument: suspend SkuResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SkuResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("qiiwpsohpbxkrgwk")
    public suspend fun providerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerNamespace = mapped
    }

    /**
     * @param value The resource type.
     */
    @JvmName("rgpyfgqrseplhaxv")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The SKU.
     */
    @JvmName("negxgbtmkertmodj")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    internal fun build(): SkusNestedResourceTypeFirstArgs = SkusNestedResourceTypeFirstArgs(
        nestedResourceTypeFirst = nestedResourceTypeFirst,
        properties = properties,
        providerNamespace = providerNamespace,
        resourceType = resourceType,
        sku = sku,
    )
}
