@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the rollout.
 * @property provisioningState The provisioned state of the resource.
 * @property specification
 * @property status
 */
public data class DefaultRolloutPropertiesArgs(
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val specification: Output<DefaultRolloutPropertiesSpecificationArgs>? = null,
    public val status: Output<DefaultRolloutPropertiesStatusArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesArgs =
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutPropertiesArgs.builder()
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .specification(specification?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DefaultRolloutPropertiesArgs].
 */
@PulumiTagMarker
public class DefaultRolloutPropertiesArgsBuilder internal constructor() {
    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var specification: Output<DefaultRolloutPropertiesSpecificationArgs>? = null

    private var status: Output<DefaultRolloutPropertiesStatusArgs>? = null

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("nhtakprojkwlfdsc")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value
     */
    @JvmName("lkievwhtjwubtwju")
    public suspend fun specification(`value`: Output<DefaultRolloutPropertiesSpecificationArgs>) {
        this.specification = value
    }

    /**
     * @param value
     */
    @JvmName("nwfdogiqgpgfijev")
    public suspend fun status(`value`: Output<DefaultRolloutPropertiesStatusArgs>) {
        this.status = value
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("ssjifwmtcxtenqqq")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("fxcrqsxvulqmahvl")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("siwqdywiwattytre")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value
     */
    @JvmName("nfljordprbvrgxpx")
    public suspend fun specification(`value`: DefaultRolloutPropertiesSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ivuqwvdsghpugesp")
    public suspend
    fun specification(argument: suspend DefaultRolloutPropertiesSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutPropertiesSpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.specification = mapped
    }

    /**
     * @param value
     */
    @JvmName("ckijvwhhgrqlvdyc")
    public suspend fun status(`value`: DefaultRolloutPropertiesStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fuyueleememkvppw")
    public suspend
    fun status(argument: suspend DefaultRolloutPropertiesStatusArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultRolloutPropertiesStatusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.status = mapped
    }

    internal fun build(): DefaultRolloutPropertiesArgs = DefaultRolloutPropertiesArgs(
        provisioningState = provisioningState,
        specification = specification,
        status = status,
    )
}
