@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationCanaryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property regions
 * @property skipRegions
 */
public data class DefaultRolloutSpecificationCanaryArgs(
    public val regions: Output<List<String>>? = null,
    public val skipRegions: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationCanaryArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationCanaryArgs =
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationCanaryArgs.builder()
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .skipRegions(skipRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DefaultRolloutSpecificationCanaryArgs].
 */
@PulumiTagMarker
public class DefaultRolloutSpecificationCanaryArgsBuilder internal constructor() {
    private var regions: Output<List<String>>? = null

    private var skipRegions: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("ckebticdgeghcoef")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("bhovsdroxsdgpapi")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("swbwgljcyvppbeid")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("wctrshkcqwdyuqkg")
    public suspend fun skipRegions(`value`: Output<List<String>>) {
        this.skipRegions = value
    }

    @JvmName("nixlkagnqlkrwbcl")
    public suspend fun skipRegions(vararg values: Output<String>) {
        this.skipRegions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ampyogwmlixdokxv")
    public suspend fun skipRegions(values: List<Output<String>>) {
        this.skipRegions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("uoehtfhlafuwdaiq")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values
     */
    @JvmName("rmvvkgbdanceymmq")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value
     */
    @JvmName("erpmpmicaddsqtjy")
    public suspend fun skipRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipRegions = mapped
    }

    /**
     * @param values
     */
    @JvmName("ppotalfbgpnbxkam")
    public suspend fun skipRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skipRegions = mapped
    }

    internal fun build(): DefaultRolloutSpecificationCanaryArgs =
        DefaultRolloutSpecificationCanaryArgs(
            regions = regions,
            skipRegions = skipRegions,
        )
}
