@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ExtendedErrorInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property additionalInfo
 * @property code
 * @property details
 * @property message
 * @property target
 */
public data class ExtendedErrorInfoArgs(
    public val additionalInfo: Output<List<TypedErrorInfoArgs>>? = null,
    public val code: Output<String>? = null,
    public val details: Output<List<ExtendedErrorInfoArgs>>? = null,
    public val message: Output<String>? = null,
    public val target: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ExtendedErrorInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ExtendedErrorInfoArgs =
        com.pulumi.azurenative.providerhub.inputs.ExtendedErrorInfoArgs.builder()
            .additionalInfo(
                additionalInfo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .code(code?.applyValue({ args0 -> args0 }))
            .details(
                details?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .message(message?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtendedErrorInfoArgs].
 */
@PulumiTagMarker
public class ExtendedErrorInfoArgsBuilder internal constructor() {
    private var additionalInfo: Output<List<TypedErrorInfoArgs>>? = null

    private var code: Output<String>? = null

    private var details: Output<List<ExtendedErrorInfoArgs>>? = null

    private var message: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qelmljjkgdbufacc")
    public suspend fun additionalInfo(`value`: Output<List<TypedErrorInfoArgs>>) {
        this.additionalInfo = value
    }

    @JvmName("fbayhtckneheirhh")
    public suspend fun additionalInfo(vararg values: Output<TypedErrorInfoArgs>) {
        this.additionalInfo = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("meysagpnlicdhmgt")
    public suspend fun additionalInfo(values: List<Output<TypedErrorInfoArgs>>) {
        this.additionalInfo = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ppqqoqtqvaddwias")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value
     */
    @JvmName("otckenqastorygmc")
    public suspend fun details(`value`: Output<List<ExtendedErrorInfoArgs>>) {
        this.details = value
    }

    @JvmName("byinujabelgfiyvh")
    public suspend fun details(vararg values: Output<ExtendedErrorInfoArgs>) {
        this.details = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("noenoxwlcomvdonx")
    public suspend fun details(values: List<Output<ExtendedErrorInfoArgs>>) {
        this.details = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gknawbsclaamkakt")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value
     */
    @JvmName("ayvoqvxagdfkcvyl")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value
     */
    @JvmName("wixxrsjvdhckmkry")
    public suspend fun additionalInfo(`value`: List<TypedErrorInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("piaksrfsrkgvpjav")
    public suspend fun additionalInfo(argument: List<suspend TypedErrorInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TypedErrorInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mekdfdehwmkdqjnr")
    public suspend fun additionalInfo(vararg argument: suspend TypedErrorInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TypedErrorInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xxphbjonlwokhqrm")
    public suspend fun additionalInfo(argument: suspend TypedErrorInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TypedErrorInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.additionalInfo = mapped
    }

    /**
     * @param values
     */
    @JvmName("nohjhjgeimacejmy")
    public suspend fun additionalInfo(vararg values: TypedErrorInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalInfo = mapped
    }

    /**
     * @param value
     */
    @JvmName("vicqymxbgcwvjdmx")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value
     */
    @JvmName("ljmadwhjjaamfhdp")
    public suspend fun details(`value`: List<ExtendedErrorInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xdodabuynehfbcve")
    public suspend fun details(argument: List<suspend ExtendedErrorInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtendedErrorInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yentacdlwtwvqrkj")
    public suspend fun details(vararg argument: suspend ExtendedErrorInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExtendedErrorInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dwleyysisturbsou")
    public suspend fun details(argument: suspend ExtendedErrorInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExtendedErrorInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    /**
     * @param values
     */
    @JvmName("dgbpytugmfekqlpr")
    public suspend fun details(vararg values: ExtendedErrorInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param value
     */
    @JvmName("nxfoshyeoulfndlk")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value
     */
    @JvmName("rpnavufxydmwmslj")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): ExtendedErrorInfoArgs = ExtendedErrorInfoArgs(
        additionalInfo = additionalInfo,
        code = code,
        details = details,
        message = message,
        target = target,
    )
}
