@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.GetSkusNestedResourceTypeThirdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nestedResourceTypeFirst The first child resource type.
 * @property nestedResourceTypeSecond The second child resource type.
 * @property nestedResourceTypeThird The third child resource type.
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property resourceType The resource type.
 * @property sku The SKU.
 */
public data class GetSkusNestedResourceTypeThirdPlainArgs(
    public val nestedResourceTypeFirst: String,
    public val nestedResourceTypeSecond: String,
    public val nestedResourceTypeThird: String,
    public val providerNamespace: String,
    public val resourceType: String,
    public val sku: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.GetSkusNestedResourceTypeThirdPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.GetSkusNestedResourceTypeThirdPlainArgs =
        com.pulumi.azurenative.providerhub.inputs.GetSkusNestedResourceTypeThirdPlainArgs.builder()
            .nestedResourceTypeFirst(nestedResourceTypeFirst.let({ args0 -> args0 }))
            .nestedResourceTypeSecond(nestedResourceTypeSecond.let({ args0 -> args0 }))
            .nestedResourceTypeThird(nestedResourceTypeThird.let({ args0 -> args0 }))
            .providerNamespace(providerNamespace.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 }))
            .sku(sku.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSkusNestedResourceTypeThirdPlainArgs].
 */
@PulumiTagMarker
public class GetSkusNestedResourceTypeThirdPlainArgsBuilder internal constructor() {
    private var nestedResourceTypeFirst: String? = null

    private var nestedResourceTypeSecond: String? = null

    private var nestedResourceTypeThird: String? = null

    private var providerNamespace: String? = null

    private var resourceType: String? = null

    private var sku: String? = null

    /**
     * @param value The first child resource type.
     */
    @JvmName("xqiuqgtcwavakidc")
    public suspend fun nestedResourceTypeFirst(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nestedResourceTypeFirst = mapped
    }

    /**
     * @param value The second child resource type.
     */
    @JvmName("togbjxmqpxwmaacx")
    public suspend fun nestedResourceTypeSecond(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nestedResourceTypeSecond = mapped
    }

    /**
     * @param value The third child resource type.
     */
    @JvmName("ujrlfncngbqsqlfo")
    public suspend fun nestedResourceTypeThird(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nestedResourceTypeThird = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("ignekfbevwdjlufm")
    public suspend fun providerNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerNamespace = mapped
    }

    /**
     * @param value The resource type.
     */
    @JvmName("abnuvwaeeftwwrhm")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    /**
     * @param value The SKU.
     */
    @JvmName("gttesdqamgogisxf")
    public suspend fun sku(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sku = mapped
    }

    internal fun build(): GetSkusNestedResourceTypeThirdPlainArgs =
        GetSkusNestedResourceTypeThirdPlainArgs(
            nestedResourceTypeFirst = nestedResourceTypeFirst ?: throw
                PulumiNullFieldException("nestedResourceTypeFirst"),
            nestedResourceTypeSecond = nestedResourceTypeSecond ?: throw
                PulumiNullFieldException("nestedResourceTypeSecond"),
            nestedResourceTypeThird = nestedResourceTypeThird ?: throw
                PulumiNullFieldException("nestedResourceTypeThird"),
            providerNamespace = providerNamespace ?: throw PulumiNullFieldException("providerNamespace"),
            resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
            sku = sku ?: throw PulumiNullFieldException("sku"),
        )
}
