@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.GetSkusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property resourceType The resource type.
 * @property sku The SKU.
 */
public data class GetSkusPlainArgs(
    public val providerNamespace: String,
    public val resourceType: String,
    public val sku: String,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.GetSkusPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.GetSkusPlainArgs =
        com.pulumi.azurenative.providerhub.inputs.GetSkusPlainArgs.builder()
            .providerNamespace(providerNamespace.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 }))
            .sku(sku.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSkusPlainArgs].
 */
@PulumiTagMarker
public class GetSkusPlainArgsBuilder internal constructor() {
    private var providerNamespace: String? = null

    private var resourceType: String? = null

    private var sku: String? = null

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("udlevhluqrldmrbp")
    public suspend fun providerNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerNamespace = mapped
    }

    /**
     * @param value The resource type.
     */
    @JvmName("bcsaawnkoqjjsrtw")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    /**
     * @param value The SKU.
     */
    @JvmName("iveqcrtxptkoyrlk")
    public suspend fun sku(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sku = mapped
    }

    internal fun build(): GetSkusPlainArgs = GetSkusPlainArgs(
        providerNamespace = providerNamespace ?: throw PulumiNullFieldException("providerNamespace"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        sku = sku ?: throw PulumiNullFieldException("sku"),
    )
}
