@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.NotificationEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property locations
 * @property notificationDestination
 */
public data class NotificationEndpointArgs(
    public val locations: Output<List<String>>? = null,
    public val notificationDestination: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.NotificationEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.NotificationEndpointArgs =
        com.pulumi.azurenative.providerhub.inputs.NotificationEndpointArgs.builder()
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notificationDestination(notificationDestination?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotificationEndpointArgs].
 */
@PulumiTagMarker
public class NotificationEndpointArgsBuilder internal constructor() {
    private var locations: Output<List<String>>? = null

    private var notificationDestination: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("vixuxtecfvntiypq")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("yaqnbgrdgoqmirdm")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("uppxtqvhbvoyulwa")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rltvrohnsqwecnot")
    public suspend fun notificationDestination(`value`: Output<String>) {
        this.notificationDestination = value
    }

    /**
     * @param value
     */
    @JvmName("gnnxdopgvptpatnp")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values
     */
    @JvmName("mmeckwffxffcbudx")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value
     */
    @JvmName("ugwtbskauulkhbyt")
    public suspend fun notificationDestination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationDestination = mapped
    }

    internal fun build(): NotificationEndpointArgs = NotificationEndpointArgs(
        locations = locations,
        notificationDestination = notificationDestination,
    )
}
