@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ProviderRegistrationPropertiesProviderHubMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property providerAuthentication
 * @property providerAuthorizations
 * @property thirdPartyProviderAuthorization
 */
public data class ProviderRegistrationPropertiesProviderHubMetadataArgs(
    public val providerAuthentication: Output<ProviderHubMetadataProviderAuthenticationArgs>? = null,
    public val providerAuthorizations: Output<List<ResourceProviderAuthorizationArgs>>? = null,
    public val thirdPartyProviderAuthorization:
    Output<ProviderHubMetadataThirdPartyProviderAuthorizationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ProviderRegistrationPropertiesProviderHubMetadataArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ProviderRegistrationPropertiesProviderHubMetadataArgs =
        com.pulumi.azurenative.providerhub.inputs.ProviderRegistrationPropertiesProviderHubMetadataArgs.builder()
            .providerAuthentication(
                providerAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .providerAuthorizations(
                providerAuthorizations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .thirdPartyProviderAuthorization(
                thirdPartyProviderAuthorization?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [ProviderRegistrationPropertiesProviderHubMetadataArgs].
 */
@PulumiTagMarker
public class ProviderRegistrationPropertiesProviderHubMetadataArgsBuilder internal constructor() {
    private var providerAuthentication: Output<ProviderHubMetadataProviderAuthenticationArgs>? = null

    private var providerAuthorizations: Output<List<ResourceProviderAuthorizationArgs>>? = null

    private var thirdPartyProviderAuthorization:
        Output<ProviderHubMetadataThirdPartyProviderAuthorizationArgs>? = null

    /**
     * @param value
     */
    @JvmName("wfagqnvhdqenxqou")
    public suspend
    fun providerAuthentication(`value`: Output<ProviderHubMetadataProviderAuthenticationArgs>) {
        this.providerAuthentication = value
    }

    /**
     * @param value
     */
    @JvmName("rbwjrabxagnbdqtl")
    public suspend
    fun providerAuthorizations(`value`: Output<List<ResourceProviderAuthorizationArgs>>) {
        this.providerAuthorizations = value
    }

    @JvmName("ifniddecwxfxjhju")
    public suspend fun providerAuthorizations(
        vararg
        values: Output<ResourceProviderAuthorizationArgs>,
    ) {
        this.providerAuthorizations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("odvtyvakxsinarmw")
    public suspend
    fun providerAuthorizations(values: List<Output<ResourceProviderAuthorizationArgs>>) {
        this.providerAuthorizations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ptupyvgfgqcwsbic")
    public suspend
    fun thirdPartyProviderAuthorization(`value`: Output<ProviderHubMetadataThirdPartyProviderAuthorizationArgs>) {
        this.thirdPartyProviderAuthorization = value
    }

    /**
     * @param value
     */
    @JvmName("bqxpdbllemnrserp")
    public suspend
    fun providerAuthentication(`value`: ProviderHubMetadataProviderAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerAuthentication = mapped
    }

    /**
     * @param argument
     */
    @JvmName("blchflepbocixhvp")
    public suspend
    fun providerAuthentication(argument: suspend ProviderHubMetadataProviderAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderHubMetadataProviderAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.providerAuthentication = mapped
    }

    /**
     * @param value
     */
    @JvmName("ceobuvocxdbxckpd")
    public suspend fun providerAuthorizations(`value`: List<ResourceProviderAuthorizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerAuthorizations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oajtuodplkonqfhw")
    public suspend
    fun providerAuthorizations(argument: List<suspend ResourceProviderAuthorizationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceProviderAuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.providerAuthorizations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wjngmkbvcfwiyihf")
    public suspend fun providerAuthorizations(
        vararg
        argument: suspend ResourceProviderAuthorizationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceProviderAuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.providerAuthorizations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("guiyqxmkxbufijlo")
    public suspend
    fun providerAuthorizations(argument: suspend ResourceProviderAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResourceProviderAuthorizationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.providerAuthorizations = mapped
    }

    /**
     * @param values
     */
    @JvmName("kkdihekqpfdprjsq")
    public suspend fun providerAuthorizations(vararg values: ResourceProviderAuthorizationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerAuthorizations = mapped
    }

    /**
     * @param value
     */
    @JvmName("sxyeklesfbucksru")
    public suspend
    fun thirdPartyProviderAuthorization(`value`: ProviderHubMetadataThirdPartyProviderAuthorizationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thirdPartyProviderAuthorization = mapped
    }

    /**
     * @param argument
     */
    @JvmName("atjlcrvowbvqjmut")
    public suspend
    fun thirdPartyProviderAuthorization(argument: suspend ProviderHubMetadataThirdPartyProviderAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderHubMetadataThirdPartyProviderAuthorizationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.thirdPartyProviderAuthorization = mapped
    }

    internal fun build(): ProviderRegistrationPropertiesProviderHubMetadataArgs =
        ProviderRegistrationPropertiesProviderHubMetadataArgs(
            providerAuthentication = providerAuthentication,
            providerAuthorizations = providerAuthorizations,
            thirdPartyProviderAuthorization = thirdPartyProviderAuthorization,
        )
}
