@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceProviderCapabilitiesArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.ResourceProviderCapabilitiesEffect
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property effect
 * @property quotaId
 * @property requiredFeatures
 */
public data class ResourceProviderCapabilitiesArgs(
    public val effect: Output<Either<String, ResourceProviderCapabilitiesEffect>>,
    public val quotaId: Output<String>,
    public val requiredFeatures: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceProviderCapabilitiesArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceProviderCapabilitiesArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderCapabilitiesArgs.builder()
            .effect(
                effect.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .quotaId(quotaId.applyValue({ args0 -> args0 }))
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ResourceProviderCapabilitiesArgs].
 */
@PulumiTagMarker
public class ResourceProviderCapabilitiesArgsBuilder internal constructor() {
    private var effect: Output<Either<String, ResourceProviderCapabilitiesEffect>>? = null

    private var quotaId: Output<String>? = null

    private var requiredFeatures: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("mfnjpkenkydiptwy")
    public suspend fun effect(`value`: Output<Either<String, ResourceProviderCapabilitiesEffect>>) {
        this.effect = value
    }

    /**
     * @param value
     */
    @JvmName("pumjvtpyiqqwxhtd")
    public suspend fun quotaId(`value`: Output<String>) {
        this.quotaId = value
    }

    /**
     * @param value
     */
    @JvmName("tnwprsxagbjbrvfc")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("eyblemguascclyir")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("idnnxnnmirijxpbq")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("couidgmtjgppvetb")
    public suspend fun effect(`value`: Either<String, ResourceProviderCapabilitiesEffect>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.effect = mapped
    }

    /**
     * @param value
     */
    @JvmName("oyqplrejvtsiymxr")
    public fun effect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceProviderCapabilitiesEffect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.effect = mapped
    }

    /**
     * @param value
     */
    @JvmName("bejbofrqnoijovhp")
    public fun effect(`value`: ResourceProviderCapabilitiesEffect) {
        val toBeMapped = Either.ofRight<String, ResourceProviderCapabilitiesEffect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.effect = mapped
    }

    /**
     * @param value
     */
    @JvmName("kjqutpfbskeycpec")
    public suspend fun quotaId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.quotaId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ujweuoiamrabjvmf")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("soojrqpojfequmrp")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    internal fun build(): ResourceProviderCapabilitiesArgs = ResourceProviderCapabilitiesArgs(
        effect = effect ?: throw PulumiNullFieldException("effect"),
        quotaId = quotaId ?: throw PulumiNullFieldException("quotaId"),
        requiredFeatures = requiredFeatures,
    )
}
