@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.EndpointType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property apiVersions
 * @property enabled
 * @property endpointType
 * @property extensions
 * @property featuresRule
 * @property locations
 * @property requiredFeatures
 * @property timeout
 */
public data class ResourceTypeEndpointArgs(
    public val apiVersions: Output<List<String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val endpointType: Output<Either<String, EndpointType>>? = null,
    public val extensions: Output<List<ResourceTypeExtensionArgs>>? = null,
    public val featuresRule: Output<ResourceTypeEndpointFeaturesRuleArgs>? = null,
    public val locations: Output<List<String>>? = null,
    public val requiredFeatures: Output<List<String>>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs.builder()
            .apiVersions(apiVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .endpointType(
                endpointType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .featuresRule(featuresRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceTypeEndpointArgs].
 */
@PulumiTagMarker
public class ResourceTypeEndpointArgsBuilder internal constructor() {
    private var apiVersions: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var endpointType: Output<Either<String, EndpointType>>? = null

    private var extensions: Output<List<ResourceTypeExtensionArgs>>? = null

    private var featuresRule: Output<ResourceTypeEndpointFeaturesRuleArgs>? = null

    private var locations: Output<List<String>>? = null

    private var requiredFeatures: Output<List<String>>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("newtbvcqitabdnhm")
    public suspend fun apiVersions(`value`: Output<List<String>>) {
        this.apiVersions = value
    }

    @JvmName("tvpxflcqbsyxdckd")
    public suspend fun apiVersions(vararg values: Output<String>) {
        this.apiVersions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("drjspygqoestooro")
    public suspend fun apiVersions(values: List<Output<String>>) {
        this.apiVersions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("vpxfelooethscypw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("mtavpjblxmswrycv")
    public suspend fun endpointType(`value`: Output<Either<String, EndpointType>>) {
        this.endpointType = value
    }

    /**
     * @param value
     */
    @JvmName("tdsodxogbclntdgn")
    public suspend fun extensions(`value`: Output<List<ResourceTypeExtensionArgs>>) {
        this.extensions = value
    }

    @JvmName("bqrfmoskytcvlbam")
    public suspend fun extensions(vararg values: Output<ResourceTypeExtensionArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("cofgrdaraiapmxsv")
    public suspend fun extensions(values: List<Output<ResourceTypeExtensionArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ysltbemltyyyqtgn")
    public suspend fun featuresRule(`value`: Output<ResourceTypeEndpointFeaturesRuleArgs>) {
        this.featuresRule = value
    }

    /**
     * @param value
     */
    @JvmName("ttwbuthymycpyqeg")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("guusmmrwmumulbxw")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yptbofecqooseder")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lstxkyqpbhelsirj")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("djnkquuivevjhnxy")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wuxpbocvxrifoxsm")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("pgmkouropcixiqqv")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value
     */
    @JvmName("yreunwqfgdboaxce")
    public suspend fun apiVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersions = mapped
    }

    /**
     * @param values
     */
    @JvmName("mxvlxmhoibbytxmw")
    public suspend fun apiVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiVersions = mapped
    }

    /**
     * @param value
     */
    @JvmName("qwurtxdsykyccndh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("trkhklbvemgvossj")
    public suspend fun endpointType(`value`: Either<String, EndpointType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value
     */
    @JvmName("cfejkiesraybdcts")
    public fun endpointType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value
     */
    @JvmName("akhrrvcgyvljitmc")
    public fun endpointType(`value`: EndpointType) {
        val toBeMapped = Either.ofRight<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value
     */
    @JvmName("yksdhoiekrxcjnjn")
    public suspend fun extensions(`value`: List<ResourceTypeExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mjvcbufshmiipilo")
    public suspend
    fun extensions(argument: List<suspend ResourceTypeExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceTypeExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gpwdenseswtmbxvc")
    public suspend fun extensions(
        vararg
        argument: suspend ResourceTypeExtensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceTypeExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ujwfcdwjfqlfjavd")
    public suspend fun extensions(argument: suspend ResourceTypeExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceTypeExtensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values
     */
    @JvmName("nlhpymfqoigvduoy")
    public suspend fun extensions(vararg values: ResourceTypeExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value
     */
    @JvmName("rsumrjlqyedymluw")
    public suspend fun featuresRule(`value`: ResourceTypeEndpointFeaturesRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featuresRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nncsnkmogxuxowex")
    public suspend
    fun featuresRule(argument: suspend ResourceTypeEndpointFeaturesRuleArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeEndpointFeaturesRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featuresRule = mapped
    }

    /**
     * @param value
     */
    @JvmName("ouoligbqseddrmrn")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values
     */
    @JvmName("vlmlemdkmcgfxbhd")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value
     */
    @JvmName("ertifkahkwuaaitj")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("xhgstpklrgglobec")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param value
     */
    @JvmName("mdvfybtcqpgqotur")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ResourceTypeEndpointArgs = ResourceTypeEndpointArgs(
        apiVersions = apiVersions,
        enabled = enabled,
        endpointType = endpointType,
        extensions = extensions,
        featuresRule = featuresRule,
        locations = locations,
        requiredFeatures = requiredFeatures,
        timeout = timeout,
    )
}
