@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property properties
 */
public data class ResourceTypeRegistrationArgs(
    public val properties: Output<ResourceTypeRegistrationPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceTypeRegistrationArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationArgsBuilder internal constructor() {
    private var properties: Output<ResourceTypeRegistrationPropertiesArgs>? = null

    /**
     * @param value
     */
    @JvmName("klpatcjqfutjluxi")
    public suspend fun properties(`value`: Output<ResourceTypeRegistrationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value
     */
    @JvmName("dacorosktvhcrdmb")
    public suspend fun properties(`value`: ResourceTypeRegistrationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gcwaolkoqboucqvu")
    public suspend
    fun properties(argument: suspend ResourceTypeRegistrationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): ResourceTypeRegistrationArgs = ResourceTypeRegistrationArgs(
        properties = properties,
    )
}
