@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesIdentityManagementArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.IdentityManagementTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationId
 * @property type
 */
public data class ResourceTypeRegistrationPropertiesIdentityManagementArgs(
    public val applicationId: Output<String>? = null,
    public val type: Output<Either<String, IdentityManagementTypes>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesIdentityManagementArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesIdentityManagementArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesIdentityManagementArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceTypeRegistrationPropertiesIdentityManagementArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationPropertiesIdentityManagementArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var type: Output<Either<String, IdentityManagementTypes>>? = null

    /**
     * @param value
     */
    @JvmName("bkrixaybhuhrvlag")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value
     */
    @JvmName("kckpekhdmncysrnv")
    public suspend fun type(`value`: Output<Either<String, IdentityManagementTypes>>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("bukasrvqigjsvvvd")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value
     */
    @JvmName("gpdsrvhxukxcluvw")
    public suspend fun type(`value`: Either<String, IdentityManagementTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("meaxajddoieogqkh")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IdentityManagementTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("vsrvgwoncthpfoxr")
    public fun type(`value`: IdentityManagementTypes) {
        val toBeMapped = Either.ofRight<String, IdentityManagementTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ResourceTypeRegistrationPropertiesIdentityManagementArgs =
        ResourceTypeRegistrationPropertiesIdentityManagementArgs(
            applicationId = applicationId,
            type = type,
        )
}
