@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.PreflightOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property preflightOptions
 * @property preflightSupported
 */
public data class ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs(
    public val preflightOptions: Output<List<Either<String, PreflightOption>>>? = null,
    public val preflightSupported: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs.builder()
            .preflightOptions(
                preflightOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .preflightSupported(preflightSupported?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgsBuilder internal
constructor() {
    private var preflightOptions: Output<List<Either<String, PreflightOption>>>? = null

    private var preflightSupported: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("vajfyofukllnmmdn")
    public suspend fun preflightOptions(`value`: Output<List<Either<String, PreflightOption>>>) {
        this.preflightOptions = value
    }

    @JvmName("uaugrhkgobnakmyu")
    public suspend fun preflightOptions(vararg values: Output<Either<String, PreflightOption>>) {
        this.preflightOptions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vxmjmaepmtbwohty")
    public suspend fun preflightOptions(values: List<Output<Either<String, PreflightOption>>>) {
        this.preflightOptions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("pqgvlygkfpimawhk")
    public suspend fun preflightSupported(`value`: Output<Boolean>) {
        this.preflightSupported = value
    }

    /**
     * @param value
     */
    @JvmName("iukdpayhxmokfyco")
    public suspend fun preflightOptions(`value`: List<Either<String, PreflightOption>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preflightOptions = mapped
    }

    /**
     * @param values
     */
    @JvmName("dmrsdskunjwwoumh")
    public suspend fun preflightOptions(vararg values: Either<String, PreflightOption>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preflightOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("ggtjiamttwvxrmaf")
    public suspend fun preflightSupported(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preflightSupported = mapped
    }

    internal fun build(): ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs =
        ResourceTypeRegistrationPropertiesTemplateDeploymentOptionsArgs(
            preflightOptions = preflightOptions,
            preflightSupported = preflightSupported,
        )
}
