@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ServiceTreeInfoArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.Readiness
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property componentId
 * @property readiness
 * @property serviceId
 */
public data class ServiceTreeInfoArgs(
    public val componentId: Output<String>? = null,
    public val readiness: Output<Either<String, Readiness>>? = null,
    public val serviceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ServiceTreeInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ServiceTreeInfoArgs =
        com.pulumi.azurenative.providerhub.inputs.ServiceTreeInfoArgs.builder()
            .componentId(componentId?.applyValue({ args0 -> args0 }))
            .readiness(
                readiness?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceId(serviceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceTreeInfoArgs].
 */
@PulumiTagMarker
public class ServiceTreeInfoArgsBuilder internal constructor() {
    private var componentId: Output<String>? = null

    private var readiness: Output<Either<String, Readiness>>? = null

    private var serviceId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fuspxqwvuklshggn")
    public suspend fun componentId(`value`: Output<String>) {
        this.componentId = value
    }

    /**
     * @param value
     */
    @JvmName("kbnrnuxreodyctvy")
    public suspend fun readiness(`value`: Output<Either<String, Readiness>>) {
        this.readiness = value
    }

    /**
     * @param value
     */
    @JvmName("iutpylhfkwkmmvgh")
    public suspend fun serviceId(`value`: Output<String>) {
        this.serviceId = value
    }

    /**
     * @param value
     */
    @JvmName("jbildhjtolswprfy")
    public suspend fun componentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ruyrnyhmlnjieecr")
    public suspend fun readiness(`value`: Either<String, Readiness>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readiness = mapped
    }

    /**
     * @param value
     */
    @JvmName("fwqghifoocvrwwpc")
    public fun readiness(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Readiness>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readiness = mapped
    }

    /**
     * @param value
     */
    @JvmName("wjgympccwrtldged")
    public fun readiness(`value`: Readiness) {
        val toBeMapped = Either.ofRight<String, Readiness>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readiness = mapped
    }

    /**
     * @param value
     */
    @JvmName("ulltcdsqvnbtaiey")
    public suspend fun serviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceId = mapped
    }

    internal fun build(): ServiceTreeInfoArgs = ServiceTreeInfoArgs(
        componentId = componentId,
        readiness = readiness,
        serviceId = serviceId,
    )
}
