@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SkuCostArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property extendedUnit
 * @property meterId
 * @property quantity
 */
public data class SkuCostArgs(
    public val extendedUnit: Output<String>? = null,
    public val meterId: Output<String>,
    public val quantity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SkuCostArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SkuCostArgs =
        com.pulumi.azurenative.providerhub.inputs.SkuCostArgs.builder()
            .extendedUnit(extendedUnit?.applyValue({ args0 -> args0 }))
            .meterId(meterId.applyValue({ args0 -> args0 }))
            .quantity(quantity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuCostArgs].
 */
@PulumiTagMarker
public class SkuCostArgsBuilder internal constructor() {
    private var extendedUnit: Output<String>? = null

    private var meterId: Output<String>? = null

    private var quantity: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("uvacqfauhdkgvecb")
    public suspend fun extendedUnit(`value`: Output<String>) {
        this.extendedUnit = value
    }

    /**
     * @param value
     */
    @JvmName("ajetlhpyornixomt")
    public suspend fun meterId(`value`: Output<String>) {
        this.meterId = value
    }

    /**
     * @param value
     */
    @JvmName("acxfmgwliceamney")
    public suspend fun quantity(`value`: Output<Int>) {
        this.quantity = value
    }

    /**
     * @param value
     */
    @JvmName("mnqukdrruvdlcgls")
    public suspend fun extendedUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedUnit = mapped
    }

    /**
     * @param value
     */
    @JvmName("vgwsyydrdujoqjqg")
    public suspend fun meterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.meterId = mapped
    }

    /**
     * @param value
     */
    @JvmName("mvxqkklwexxedlaj")
    public suspend fun quantity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quantity = mapped
    }

    internal fun build(): SkuCostArgs = SkuCostArgs(
        extendedUnit = extendedUnit,
        meterId = meterId ?: throw PulumiNullFieldException("meterId"),
        quantity = quantity,
    )
}
