@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SkuResourcePropertiesArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property provisioningState The provisioned state of the resource.
 * @property skuSettings
 */
public data class SkuResourcePropertiesArgs(
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val skuSettings: Output<List<SkuSettingArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SkuResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SkuResourcePropertiesArgs =
        com.pulumi.azurenative.providerhub.inputs.SkuResourcePropertiesArgs.builder()
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .skuSettings(
                skuSettings.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuResourcePropertiesArgs].
 */
@PulumiTagMarker
public class SkuResourcePropertiesArgsBuilder internal constructor() {
    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var skuSettings: Output<List<SkuSettingArgs>>? = null

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("leirinehmwuscrpu")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value
     */
    @JvmName("piwsjlamhlpqores")
    public suspend fun skuSettings(`value`: Output<List<SkuSettingArgs>>) {
        this.skuSettings = value
    }

    @JvmName("hvajbjkhepfsrgmv")
    public suspend fun skuSettings(vararg values: Output<SkuSettingArgs>) {
        this.skuSettings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ugvwteuhlunegtlm")
    public suspend fun skuSettings(values: List<Output<SkuSettingArgs>>) {
        this.skuSettings = Output.all(values)
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("twgqalkmxtikrowl")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("vombtfkpiajqcvpp")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("auystossdppohvqn")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value
     */
    @JvmName("uxljcdpdkyfnixmb")
    public suspend fun skuSettings(`value`: List<SkuSettingArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skuSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fdxprkyygywasmsi")
    public suspend fun skuSettings(argument: List<suspend SkuSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SkuSettingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.skuSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("haonacjfllxgrbgn")
    public suspend fun skuSettings(vararg argument: suspend SkuSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SkuSettingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.skuSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ledxtqpiwdqykjlx")
    public suspend fun skuSettings(argument: suspend SkuSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.skuSettings = mapped
    }

    /**
     * @param values
     */
    @JvmName("dbpygswtmpapehvb")
    public suspend fun skuSettings(vararg values: SkuSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skuSettings = mapped
    }

    internal fun build(): SkuResourcePropertiesArgs = SkuResourcePropertiesArgs(
        provisioningState = provisioningState,
        skuSettings = skuSettings ?: throw PulumiNullFieldException("skuSettings"),
    )
}
