@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SubscriptionStateOverrideActionArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.SubscriptionNotificationOperation
import com.pulumi.azurenative.providerhub.kotlin.enums.SubscriptionTransitioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action
 * @property state
 */
public data class SubscriptionStateOverrideActionArgs(
    public val action: Output<Either<String, SubscriptionNotificationOperation>>,
    public val state: Output<Either<String, SubscriptionTransitioningState>>,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SubscriptionStateOverrideActionArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.SubscriptionStateOverrideActionArgs =
        com.pulumi.azurenative.providerhub.inputs.SubscriptionStateOverrideActionArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .state(
                state.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SubscriptionStateOverrideActionArgs].
 */
@PulumiTagMarker
public class SubscriptionStateOverrideActionArgsBuilder internal constructor() {
    private var action: Output<Either<String, SubscriptionNotificationOperation>>? = null

    private var state: Output<Either<String, SubscriptionTransitioningState>>? = null

    /**
     * @param value
     */
    @JvmName("oksfifvksysxhhno")
    public suspend fun action(`value`: Output<Either<String, SubscriptionNotificationOperation>>) {
        this.action = value
    }

    /**
     * @param value
     */
    @JvmName("ikpaxrhwjsntmgjb")
    public suspend fun state(`value`: Output<Either<String, SubscriptionTransitioningState>>) {
        this.state = value
    }

    /**
     * @param value
     */
    @JvmName("tncasbjqclimioxg")
    public suspend fun action(`value`: Either<String, SubscriptionNotificationOperation>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value
     */
    @JvmName("ixiphfsxexjcqgci")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SubscriptionNotificationOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value
     */
    @JvmName("frotkrtqlsohunbl")
    public fun action(`value`: SubscriptionNotificationOperation) {
        val toBeMapped = Either.ofRight<String, SubscriptionNotificationOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value
     */
    @JvmName("fyvbrrxbmmyjspga")
    public suspend fun state(`value`: Either<String, SubscriptionTransitioningState>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value
     */
    @JvmName("woyaqejwwyuvnkbn")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SubscriptionTransitioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value
     */
    @JvmName("rcdfahmahgayswcm")
    public fun state(`value`: SubscriptionTransitioningState) {
        val toBeMapped = Either.ofRight<String, SubscriptionTransitioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): SubscriptionStateOverrideActionArgs = SubscriptionStateOverrideActionArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        state = state ?: throw PulumiNullFieldException("state"),
    )
}
