@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SwaggerSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property apiVersions
 * @property swaggerSpecFolderUri
 */
public data class SwaggerSpecificationArgs(
    public val apiVersions: Output<List<String>>? = null,
    public val swaggerSpecFolderUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SwaggerSpecificationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SwaggerSpecificationArgs =
        com.pulumi.azurenative.providerhub.inputs.SwaggerSpecificationArgs.builder()
            .apiVersions(apiVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .swaggerSpecFolderUri(swaggerSpecFolderUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SwaggerSpecificationArgs].
 */
@PulumiTagMarker
public class SwaggerSpecificationArgsBuilder internal constructor() {
    private var apiVersions: Output<List<String>>? = null

    private var swaggerSpecFolderUri: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("hgjfgbnyyiuvfpxo")
    public suspend fun apiVersions(`value`: Output<List<String>>) {
        this.apiVersions = value
    }

    @JvmName("mwlpbeaimfuswlwg")
    public suspend fun apiVersions(vararg values: Output<String>) {
        this.apiVersions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("scbdrndlsnhebjvo")
    public suspend fun apiVersions(values: List<Output<String>>) {
        this.apiVersions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("wfbrdttpfgevwkrp")
    public suspend fun swaggerSpecFolderUri(`value`: Output<String>) {
        this.swaggerSpecFolderUri = value
    }

    /**
     * @param value
     */
    @JvmName("xygmmpujqfxbxkvs")
    public suspend fun apiVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersions = mapped
    }

    /**
     * @param values
     */
    @JvmName("bxuatimqfjshwunb")
    public suspend fun apiVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiVersions = mapped
    }

    /**
     * @param value
     */
    @JvmName("khfwylktpwvkxorj")
    public suspend fun swaggerSpecFolderUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swaggerSpecFolderUri = mapped
    }

    internal fun build(): SwaggerSpecificationArgs = SwaggerSpecificationArgs(
        apiVersions = apiVersions,
        swaggerSpecFolderUri = swaggerSpecFolderUri,
    )
}
