@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionName
 * @property linkedAction
 * @property linkedActionVerb
 * @property linkedProperty
 * @property linkedType
 */
public data class LinkedAccessCheckResponse(
    public val actionName: String? = null,
    public val linkedAction: String? = null,
    public val linkedActionVerb: String? = null,
    public val linkedProperty: String? = null,
    public val linkedType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.LinkedAccessCheckResponse):
            LinkedAccessCheckResponse = LinkedAccessCheckResponse(
            actionName = javaType.actionName().map({ args0 -> args0 }).orElse(null),
            linkedAction = javaType.linkedAction().map({ args0 -> args0 }).orElse(null),
            linkedActionVerb = javaType.linkedActionVerb().map({ args0 -> args0 }).orElse(null),
            linkedProperty = javaType.linkedProperty().map({ args0 -> args0 }).orElse(null),
            linkedType = javaType.linkedType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
