@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.inputs

import com.pulumi.azurenative.purview.inputs.CredentialsArgs.builder
import com.pulumi.azurenative.purview.kotlin.enums.CredentialsType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Credentials to access the event streaming service attached to the purview account.
 * @property identityId Identity identifier for UserAssign type.
 * @property type Identity Type.
 */
public data class CredentialsArgs(
    public val identityId: Output<String>? = null,
    public val type: Output<Either<String, CredentialsType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.purview.inputs.CredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.purview.inputs.CredentialsArgs =
        com.pulumi.azurenative.purview.inputs.CredentialsArgs.builder()
            .identityId(identityId?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CredentialsArgs].
 */
@PulumiTagMarker
public class CredentialsArgsBuilder internal constructor() {
    private var identityId: Output<String>? = null

    private var type: Output<Either<String, CredentialsType>>? = null

    /**
     * @param value Identity identifier for UserAssign type.
     */
    @JvmName("pdykffqbnttvqqgp")
    public suspend fun identityId(`value`: Output<String>) {
        this.identityId = value
    }

    /**
     * @param value Identity Type.
     */
    @JvmName("aghxugbavfpknnpo")
    public suspend fun type(`value`: Output<Either<String, CredentialsType>>) {
        this.type = value
    }

    /**
     * @param value Identity identifier for UserAssign type.
     */
    @JvmName("bqjfjxjyfdmumovb")
    public suspend fun identityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityId = mapped
    }

    /**
     * @param value Identity Type.
     */
    @JvmName("dckgcgrxbanyqksb")
    public suspend fun type(`value`: Either<String, CredentialsType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity Type.
     */
    @JvmName("kdrrxymyycjbamqg")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CredentialsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity Type.
     */
    @JvmName("ngbovjtrkapacasx")
    public fun type(`value`: CredentialsType) {
        val toBeMapped = Either.ofRight<String, CredentialsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CredentialsArgs = CredentialsArgs(
        identityId = identityId,
        type = type,
    )
}
