@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Account access keys.
 * @property atlasKafkaPrimaryEndpoint Gets or sets the primary connection string.
 * @property atlasKafkaSecondaryEndpoint Gets or sets the secondary connection string.
 */
public data class ListAccountKeysResult(
    public val atlasKafkaPrimaryEndpoint: String? = null,
    public val atlasKafkaSecondaryEndpoint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.ListAccountKeysResult):
            ListAccountKeysResult = ListAccountKeysResult(
            atlasKafkaPrimaryEndpoint = javaType.atlasKafkaPrimaryEndpoint().map({ args0 ->
                args0
            }).orElse(null),
            atlasKafkaSecondaryEndpoint = javaType.atlasKafkaSecondaryEndpoint().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
