@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A private endpoint connection class.
 * @property id Gets or sets the identifier.
 * @property name Gets or sets the name.
 * @property privateEndpoint The private endpoint information.
 * @property privateLinkServiceConnectionState The private link service connection state.
 * @property provisioningState The provisioning state.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type Gets or sets the type.
 */
public data class PrivateEndpointConnectionResponse(
    public val id: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
    public val systemData: ProxyResourceResponseSystemData,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.PrivateEndpointConnectionResponse):
            PrivateEndpointConnectionResponse = PrivateEndpointConnectionResponse(
            id = javaType.id(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.purview.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.purview.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.purview.kotlin.outputs.ProxyResourceResponseSystemData.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
