@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin.inputs

import com.pulumi.azurenative.quantum.inputs.ProviderArgs.builder
import com.pulumi.azurenative.quantum.kotlin.enums.Status
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about a Provider. A Provider is an entity that offers Targets to run Azure Quantum Jobs.
 * @property applicationName The provider's marketplace application display name.
 * @property instanceUri A Uri identifying the specific instance of this provider.
 * @property providerId Unique id of this provider.
 * @property providerSku The sku associated with pricing information for this provider.
 * @property provisioningState Provisioning status field
 * @property resourceUsageId Id to track resource usage for the provider.
 */
public data class ProviderArgs(
    public val applicationName: Output<String>? = null,
    public val instanceUri: Output<String>? = null,
    public val providerId: Output<String>? = null,
    public val providerSku: Output<String>? = null,
    public val provisioningState: Output<Either<String, Status>>? = null,
    public val resourceUsageId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.quantum.inputs.ProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.quantum.inputs.ProviderArgs =
        com.pulumi.azurenative.quantum.inputs.ProviderArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .instanceUri(instanceUri?.applyValue({ args0 -> args0 }))
            .providerId(providerId?.applyValue({ args0 -> args0 }))
            .providerSku(providerSku?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceUsageId(resourceUsageId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderArgs].
 */
@PulumiTagMarker
public class ProviderArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var instanceUri: Output<String>? = null

    private var providerId: Output<String>? = null

    private var providerSku: Output<String>? = null

    private var provisioningState: Output<Either<String, Status>>? = null

    private var resourceUsageId: Output<String>? = null

    /**
     * @param value The provider's marketplace application display name.
     */
    @JvmName("stdpkwqfuwbthjwf")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value A Uri identifying the specific instance of this provider.
     */
    @JvmName("ebxixwuwgmnwmksv")
    public suspend fun instanceUri(`value`: Output<String>) {
        this.instanceUri = value
    }

    /**
     * @param value Unique id of this provider.
     */
    @JvmName("iophetwnmatidlmv")
    public suspend fun providerId(`value`: Output<String>) {
        this.providerId = value
    }

    /**
     * @param value The sku associated with pricing information for this provider.
     */
    @JvmName("bmltkiyncxuobgmq")
    public suspend fun providerSku(`value`: Output<String>) {
        this.providerSku = value
    }

    /**
     * @param value Provisioning status field
     */
    @JvmName("eddajcrvmqijeygm")
    public suspend fun provisioningState(`value`: Output<Either<String, Status>>) {
        this.provisioningState = value
    }

    /**
     * @param value Id to track resource usage for the provider.
     */
    @JvmName("keifcxmijudcqqpq")
    public suspend fun resourceUsageId(`value`: Output<String>) {
        this.resourceUsageId = value
    }

    /**
     * @param value The provider's marketplace application display name.
     */
    @JvmName("cwikbdftyccnopif")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value A Uri identifying the specific instance of this provider.
     */
    @JvmName("imaclgfqwrewbedm")
    public suspend fun instanceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceUri = mapped
    }

    /**
     * @param value Unique id of this provider.
     */
    @JvmName("hdulsicyaneelahg")
    public suspend fun providerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerId = mapped
    }

    /**
     * @param value The sku associated with pricing information for this provider.
     */
    @JvmName("mtiwfugulyoxxhng")
    public suspend fun providerSku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerSku = mapped
    }

    /**
     * @param value Provisioning status field
     */
    @JvmName("dvcbdmppwgklxama")
    public suspend fun provisioningState(`value`: Either<String, Status>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning status field
     */
    @JvmName("geimkqaiurfclsar")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning status field
     */
    @JvmName("gauqjlrmmqyvlupw")
    public fun provisioningState(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Id to track resource usage for the provider.
     */
    @JvmName("eftbxcijauthhipi")
    public suspend fun resourceUsageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUsageId = mapped
    }

    internal fun build(): ProviderArgs = ProviderArgs(
        applicationName = applicationName,
        instanceUri = instanceUri,
        providerId = providerId,
        providerSku = providerSku,
        provisioningState = provisioningState,
        resourceUsageId = resourceUsageId,
    )
}
