@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin

import com.pulumi.azurenative.quota.kotlin.outputs.GroupQuotaSubscriptionIdResponseProperties
import com.pulumi.azurenative.quota.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.quota.kotlin.outputs.GroupQuotaSubscriptionIdResponseProperties.Companion.toKotlin as groupQuotaSubscriptionIdResponsePropertiesToKotlin
import com.pulumi.azurenative.quota.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [GroupQuotaSubscription].
 */
@PulumiTagMarker
public class GroupQuotaSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupQuotaSubscriptionArgs = GroupQuotaSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupQuotaSubscriptionArgsBuilder.() -> Unit) {
        val builder = GroupQuotaSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GroupQuotaSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.quota.GroupQuotaSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GroupQuotaSubscription(builtJavaResource)
    }
}

/**
 * This represents a Azure subscriptionId that is associated with a GroupQuotaSEntity.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### GroupQuotaSubscriptions_Put_Subscriptions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var groupQuotaSubscription = new AzureNative.Quota.GroupQuotaSubscription("groupQuotaSubscription", new()
 *     {
 *         GroupQuotaName = "groupquota1",
 *         MgId = "E7EC67B3-7657-4966-BFFC-41EFD36BAA09",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/quota/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quota.NewGroupQuotaSubscription(ctx, "groupQuotaSubscription", &quota.GroupQuotaSubscriptionArgs{
 * 			GroupQuotaName: pulumi.String("groupquota1"),
 * 			MgId:           pulumi.String("E7EC67B3-7657-4966-BFFC-41EFD36BAA09"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.quota.GroupQuotaSubscription;
 * import com.pulumi.azurenative.quota.GroupQuotaSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var groupQuotaSubscription = new GroupQuotaSubscription("groupQuotaSubscription", GroupQuotaSubscriptionArgs.builder()
 *             .groupQuotaName("groupquota1")
 *             .mgId("E7EC67B3-7657-4966-BFFC-41EFD36BAA09")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:quota:GroupQuotaSubscription 00000000-0000-0000-0000-000000000000 /providers/Microsoft.Management/managementGroups/{mgId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptions/{subscriptionId}
 * ```
 */
public class GroupQuotaSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.quota.GroupQuotaSubscription,
) : KotlinCustomResource(javaResource, GroupQuotaSubscriptionMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<GroupQuotaSubscriptionIdResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                groupQuotaSubscriptionIdResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GroupQuotaSubscriptionMapper : ResourceMapper<GroupQuotaSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.quota.GroupQuotaSubscription::class == javaResource::class

    override fun map(javaResource: Resource): GroupQuotaSubscription =
        GroupQuotaSubscription(javaResource as com.pulumi.azurenative.quota.GroupQuotaSubscription)
}

/**
 * @see [GroupQuotaSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupQuotaSubscription].
 */
public suspend fun groupQuotaSubscription(
    name: String,
    block: suspend GroupQuotaSubscriptionResourceBuilder.() -> Unit,
): GroupQuotaSubscription {
    val builder = GroupQuotaSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupQuotaSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupQuotaSubscription(name: String): GroupQuotaSubscription {
    val builder = GroupQuotaSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
