@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin

import com.pulumi.azurenative.quota.GroupQuotaSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This represents a Azure subscriptionId that is associated with a GroupQuotaSEntity.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### GroupQuotaSubscriptions_Put_Subscriptions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var groupQuotaSubscription = new AzureNative.Quota.GroupQuotaSubscription("groupQuotaSubscription", new()
 *     {
 *         GroupQuotaName = "groupquota1",
 *         MgId = "E7EC67B3-7657-4966-BFFC-41EFD36BAA09",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/quota/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quota.NewGroupQuotaSubscription(ctx, "groupQuotaSubscription", &quota.GroupQuotaSubscriptionArgs{
 * 			GroupQuotaName: pulumi.String("groupquota1"),
 * 			MgId:           pulumi.String("E7EC67B3-7657-4966-BFFC-41EFD36BAA09"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.quota.GroupQuotaSubscription;
 * import com.pulumi.azurenative.quota.GroupQuotaSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var groupQuotaSubscription = new GroupQuotaSubscription("groupQuotaSubscription", GroupQuotaSubscriptionArgs.builder()
 *             .groupQuotaName("groupquota1")
 *             .mgId("E7EC67B3-7657-4966-BFFC-41EFD36BAA09")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:quota:GroupQuotaSubscription 00000000-0000-0000-0000-000000000000 /providers/Microsoft.Management/managementGroups/{mgId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptions/{subscriptionId}
 * ```
 * @property groupQuotaName The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
 * @property mgId Management Group Id.
 */
public data class GroupQuotaSubscriptionArgs(
    public val groupQuotaName: Output<String>? = null,
    public val mgId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.quota.GroupQuotaSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.quota.GroupQuotaSubscriptionArgs =
        com.pulumi.azurenative.quota.GroupQuotaSubscriptionArgs.builder()
            .groupQuotaName(groupQuotaName?.applyValue({ args0 -> args0 }))
            .mgId(mgId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupQuotaSubscriptionArgs].
 */
@PulumiTagMarker
public class GroupQuotaSubscriptionArgsBuilder internal constructor() {
    private var groupQuotaName: Output<String>? = null

    private var mgId: Output<String>? = null

    /**
     * @param value The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
     */
    @JvmName("joclcymiqjyqnwdj")
    public suspend fun groupQuotaName(`value`: Output<String>) {
        this.groupQuotaName = value
    }

    /**
     * @param value Management Group Id.
     */
    @JvmName("pqkoxtqdbolmqrxp")
    public suspend fun mgId(`value`: Output<String>) {
        this.mgId = value
    }

    /**
     * @param value The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
     */
    @JvmName("tvwagsgddtvmcesj")
    public suspend fun groupQuotaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupQuotaName = mapped
    }

    /**
     * @param value Management Group Id.
     */
    @JvmName("xudntbadljswkgsc")
    public suspend fun mgId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mgId = mapped
    }

    internal fun build(): GroupQuotaSubscriptionArgs = GroupQuotaSubscriptionArgs(
        groupQuotaName = groupQuotaName,
        mgId = mgId,
    )
}
