@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.inputs

import com.pulumi.azurenative.quota.inputs.GroupQuotasEntityBaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
 * @property additionalAttributes Additional attributes to allow subscription, which can be added to the subscriptionIds.
 * @property displayName Display name of the GroupQuota entity.
 */
public data class GroupQuotasEntityBaseArgs(
    public val additionalAttributes: Output<AdditionalAttributesArgs>? = null,
    public val displayName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.quota.inputs.GroupQuotasEntityBaseArgs> {
    override fun toJava(): com.pulumi.azurenative.quota.inputs.GroupQuotasEntityBaseArgs =
        com.pulumi.azurenative.quota.inputs.GroupQuotasEntityBaseArgs.builder()
            .additionalAttributes(
                additionalAttributes?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupQuotasEntityBaseArgs].
 */
@PulumiTagMarker
public class GroupQuotasEntityBaseArgsBuilder internal constructor() {
    private var additionalAttributes: Output<AdditionalAttributesArgs>? = null

    private var displayName: Output<String>? = null

    /**
     * @param value Additional attributes to allow subscription, which can be added to the subscriptionIds.
     */
    @JvmName("nshqdmufduefsynf")
    public suspend fun additionalAttributes(`value`: Output<AdditionalAttributesArgs>) {
        this.additionalAttributes = value
    }

    /**
     * @param value Display name of the GroupQuota entity.
     */
    @JvmName("jgaccgijxldyoaqc")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Additional attributes to allow subscription, which can be added to the subscriptionIds.
     */
    @JvmName("xvkjrvnfvqkipesn")
    public suspend fun additionalAttributes(`value`: AdditionalAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalAttributes = mapped
    }

    /**
     * @param argument Additional attributes to allow subscription, which can be added to the subscriptionIds.
     */
    @JvmName("qgbvccpxlrgevjpn")
    public suspend
    fun additionalAttributes(argument: suspend AdditionalAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = AdditionalAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.additionalAttributes = mapped
    }

    /**
     * @param value Display name of the GroupQuota entity.
     */
    @JvmName("lmfhdjjwtjkpuinj")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    internal fun build(): GroupQuotasEntityBaseArgs = GroupQuotasEntityBaseArgs(
        additionalAttributes = additionalAttributes,
        displayName = displayName,
    )
}
