@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin

import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.AccountResourceResponseProperties
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.AccountResourceResponseProperties.Companion.toKotlin as accountResourceResponsePropertiesToKotlin
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource =
            com.pulumi.azurenative.recommendationsservice.Account(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Account(builtJavaResource)
    }
}

/**
 * Account resource details.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2022-03-01-preview.
 * ## Example Usage
 * ### Create or update RecommendationsService Account resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.RecommendationsService.Account("account", new()
 *     {
 *         AccountName = "sampleAccount",
 *         Location = "West US",
 *         Properties = new AzureNative.RecommendationsService.Inputs.AccountResourcePropertiesArgs
 *         {
 *             Configuration = "Capacity",
 *             EndpointAuthentications = new[]
 *             {
 *                 new AzureNative.RecommendationsService.Inputs.EndpointAuthenticationArgs
 *                 {
 *                     AadTenantID = "tenant",
 *                     PrincipalID = "oid",
 *                     PrincipalType = "User",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         Tags =
 *         {
 *             { "Environment", "Prod" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recommendationsservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recommendationsservice.NewAccount(ctx, "account", &recommendationsservice.AccountArgs{
 * 			AccountName: pulumi.String("sampleAccount"),
 * 			Location:    pulumi.String("West US"),
 * 			Properties: recommendationsservice.AccountResourceResponseProperties{
 * 				Configuration: pulumi.String("Capacity"),
 * 				EndpointAuthentications: recommendationsservice.EndpointAuthenticationArray{
 * 					&recommendationsservice.EndpointAuthenticationArgs{
 * 						AadTenantID:   pulumi.String("tenant"),
 * 						PrincipalID:   pulumi.String("oid"),
 * 						PrincipalType: pulumi.String("User"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Prod"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recommendationsservice.Account;
 * import com.pulumi.azurenative.recommendationsservice.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("sampleAccount")
 *             .location("West US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("configuration", "Capacity"),
 *                 Map.entry("endpointAuthentications", Map.ofEntries(
 *                     Map.entry("aadTenantID", "tenant"),
 *                     Map.entry("principalID", "oid"),
 *                     Map.entry("principalType", "User")
 *                 ))
 *             ))
 *             .resourceGroupName("rg")
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recommendationsservice:Account sampleAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecommendationsService/accounts/{accountName}
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.azurenative.recommendationsservice.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Account resource properties.
     */
    public val properties: Output<AccountResourceResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                accountResourceResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recommendationsservice.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.azurenative.recommendationsservice.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit):
    Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
