@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin

import com.pulumi.azurenative.recommendationsservice.RecommendationsserviceFunctions.getAccountPlain
import com.pulumi.azurenative.recommendationsservice.RecommendationsserviceFunctions.getModelingPlain
import com.pulumi.azurenative.recommendationsservice.RecommendationsserviceFunctions.getServiceEndpointPlain
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.GetModelingPlainArgs
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.GetModelingPlainArgsBuilder
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.GetServiceEndpointPlainArgs
import com.pulumi.azurenative.recommendationsservice.kotlin.inputs.GetServiceEndpointPlainArgsBuilder
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.GetModelingResult
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.GetServiceEndpointResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.GetModelingResult.Companion.toKotlin as getModelingResultToKotlin
import com.pulumi.azurenative.recommendationsservice.kotlin.outputs.GetServiceEndpointResult.Companion.toKotlin as getServiceEndpointResultToKotlin

public object RecommendationsserviceFunctions {
    /**
     * Returns RecommendationsService Account resource for a given name.
     * Azure REST API version: 2022-02-01.
     * Other available API versions: 2022-03-01-preview.
     * @param argument null
     * @return Account resource details.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of the RecommendationsService Account resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Account resource details.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recommendationsservice&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return Account resource details.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns Modeling resources for a given name.
     * Azure REST API version: 2022-02-01.
     * Other available API versions: 2022-03-01-preview.
     * @param argument null
     * @return Modeling resource details.
     */
    public suspend fun getModeling(argument: GetModelingPlainArgs): GetModelingResult =
        getModelingResultToKotlin(getModelingPlain(argument.toJava()).await())

    /**
     * @see [getModeling].
     * @param accountName The name of the RecommendationsService Account resource.
     * @param modelingName The name of the Modeling resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Modeling resource details.
     */
    public suspend fun getModeling(
        accountName: String,
        modelingName: String,
        resourceGroupName: String,
    ): GetModelingResult {
        val argument = GetModelingPlainArgs(
            accountName = accountName,
            modelingName = modelingName,
            resourceGroupName = resourceGroupName,
        )
        return getModelingResultToKotlin(getModelingPlain(argument.toJava()).await())
    }

    /**
     * @see [getModeling].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recommendationsservice&#46;kotlin&#46;inputs&#46;GetModelingPlainArgs].
     * @return Modeling resource details.
     */
    public suspend fun getModeling(argument: suspend GetModelingPlainArgsBuilder.() -> Unit):
        GetModelingResult {
        val builder = GetModelingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getModelingResultToKotlin(getModelingPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns ServiceEndpoint resources for a given name.
     * Azure REST API version: 2022-02-01.
     * Other available API versions: 2022-03-01-preview.
     * @param argument null
     * @return ServiceEndpoint resource details.
     */
    public suspend fun getServiceEndpoint(argument: GetServiceEndpointPlainArgs):
        GetServiceEndpointResult =
        getServiceEndpointResultToKotlin(getServiceEndpointPlain(argument.toJava()).await())

    /**
     * @see [getServiceEndpoint].
     * @param accountName The name of the RecommendationsService Account resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceEndpointName The name of the ServiceEndpoint resource.
     * @return ServiceEndpoint resource details.
     */
    public suspend fun getServiceEndpoint(
        accountName: String,
        resourceGroupName: String,
        serviceEndpointName: String,
    ): GetServiceEndpointResult {
        val argument = GetServiceEndpointPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            serviceEndpointName = serviceEndpointName,
        )
        return getServiceEndpointResultToKotlin(getServiceEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;recommendationsservice&#46;kotlin&#46;inputs&#46;GetServiceEndpointPlainArgs].
     * @return ServiceEndpoint resource details.
     */
    public suspend
    fun getServiceEndpoint(argument: suspend GetServiceEndpointPlainArgsBuilder.() -> Unit):
        GetServiceEndpointResult {
        val builder = GetServiceEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceEndpointResultToKotlin(getServiceEndpointPlain(builtArgument.toJava()).await())
    }
}
