@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.inputs

import com.pulumi.azurenative.recommendationsservice.inputs.EndpointAuthenticationArgs.builder
import com.pulumi.azurenative.recommendationsservice.kotlin.enums.PrincipalType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Service endpoints authentication details.
 * @property aadTenantID AAD tenant ID.
 * @property principalID AAD principal ID.
 * @property principalType AAD principal type.
 */
public data class EndpointAuthenticationArgs(
    public val aadTenantID: Output<String>? = null,
    public val principalID: Output<String>? = null,
    public val principalType: Output<Either<String, PrincipalType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.inputs.EndpointAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.recommendationsservice.inputs.EndpointAuthenticationArgs =
        com.pulumi.azurenative.recommendationsservice.inputs.EndpointAuthenticationArgs.builder()
            .aadTenantID(aadTenantID?.applyValue({ args0 -> args0 }))
            .principalID(principalID?.applyValue({ args0 -> args0 }))
            .principalType(
                principalType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EndpointAuthenticationArgs].
 */
@PulumiTagMarker
public class EndpointAuthenticationArgsBuilder internal constructor() {
    private var aadTenantID: Output<String>? = null

    private var principalID: Output<String>? = null

    private var principalType: Output<Either<String, PrincipalType>>? = null

    /**
     * @param value AAD tenant ID.
     */
    @JvmName("sousrtkoasdtjpbu")
    public suspend fun aadTenantID(`value`: Output<String>) {
        this.aadTenantID = value
    }

    /**
     * @param value AAD principal ID.
     */
    @JvmName("vjgxpappfvypujdb")
    public suspend fun principalID(`value`: Output<String>) {
        this.principalID = value
    }

    /**
     * @param value AAD principal type.
     */
    @JvmName("vdfdjgfdadbngwgp")
    public suspend fun principalType(`value`: Output<Either<String, PrincipalType>>) {
        this.principalType = value
    }

    /**
     * @param value AAD tenant ID.
     */
    @JvmName("moiblvfeinriqnft")
    public suspend fun aadTenantID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadTenantID = mapped
    }

    /**
     * @param value AAD principal ID.
     */
    @JvmName("mblngwitlwvstywn")
    public suspend fun principalID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalID = mapped
    }

    /**
     * @param value AAD principal type.
     */
    @JvmName("soxavocodurvsltx")
    public suspend fun principalType(`value`: Either<String, PrincipalType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value AAD principal type.
     */
    @JvmName("rkhkyiqllytisdnv")
    public fun principalType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value AAD principal type.
     */
    @JvmName("yjjysfedueajthhn")
    public fun principalType(`value`: PrincipalType) {
        val toBeMapped = Either.ofRight<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    internal fun build(): EndpointAuthenticationArgs = EndpointAuthenticationArgs(
        aadTenantID = aadTenantID,
        principalID = principalID,
        principalType = principalType,
    )
}
