@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * ServiceEndpoint resource properties.
 * @property pairedLocation The paired location that will be used by this ServiceEndpoint.
 * @property preAllocatedCapacity ServiceEndpoint pre-allocated capacity controls the maximum requests-per-second allowed for that endpoint. Only applicable when Account configuration is Capacity.
 * @property provisioningState The resource provisioning state.
 * @property url The URL where the ServiceEndpoint API is accessible at.
 */
public data class ServiceEndpointResourceResponseProperties(
    public val pairedLocation: String,
    public val preAllocatedCapacity: Int? = null,
    public val provisioningState: String,
    public val url: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recommendationsservice.outputs.ServiceEndpointResourceResponseProperties):
            ServiceEndpointResourceResponseProperties = ServiceEndpointResourceResponseProperties(
            pairedLocation = javaType.pairedLocation(),
            preAllocatedCapacity = javaType.preAllocatedCapacity().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            url = javaType.url(),
        )
    }
}
