@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ProtectionContainer].
 */
@PulumiTagMarker
public class ProtectionContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectionContainerArgs = ProtectionContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectionContainerArgsBuilder.() -> Unit) {
        val builder = ProtectionContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProtectionContainer {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ProtectionContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProtectionContainer(builtJavaResource)
    }
}

/**
 * Base class for container with backup items. Containers with specific workloads are derived from this class.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-06-01, 2023-08-01.
 * ## Example Usage
 * ### RegisterAzure Storage ProtectionContainers
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionContainer = new AzureNative.RecoveryServices.ProtectionContainer("protectionContainer", new()
 *     {
 *         ContainerName = "StorageContainer;Storage;SwaggerTestRg;swaggertestsa",
 *         FabricName = "Azure",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureStorageContainerArgs
 *         {
 *             AcquireStorageAccountLock = "Acquire",
 *             BackupManagementType = "AzureStorage",
 *             ContainerType = "StorageContainer",
 *             FriendlyName = "swaggertestsa",
 *             SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/SwaggerTestRg/providers/Microsoft.Storage/storageAccounts/swaggertestsa",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "swaggertestvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionContainer(ctx, "protectionContainer", &recoveryservices.ProtectionContainerArgs{
 * 			ContainerName: pulumi.String("StorageContainer;Storage;SwaggerTestRg;swaggertestsa"),
 * 			FabricName:    pulumi.String("Azure"),
 * 			Properties: recoveryservices.AzureStorageContainer{
 * 				AcquireStorageAccountLock: "Acquire",
 * 				BackupManagementType:      "AzureStorage",
 * 				ContainerType:             "StorageContainer",
 * 				FriendlyName:              "swaggertestsa",
 * 				SourceResourceId:          "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/SwaggerTestRg/providers/Microsoft.Storage/storageAccounts/swaggertestsa",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("swaggertestvault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionContainer;
 * import com.pulumi.azurenative.recoveryservices.ProtectionContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionContainer = new ProtectionContainer("protectionContainer", ProtectionContainerArgs.builder()
 *             .containerName("StorageContainer;Storage;SwaggerTestRg;swaggertestsa")
 *             .fabricName("Azure")
 *             .properties(Map.ofEntries(
 *                 Map.entry("acquireStorageAccountLock", "Acquire"),
 *                 Map.entry("backupManagementType", "AzureStorage"),
 *                 Map.entry("containerType", "StorageContainer"),
 *                 Map.entry("friendlyName", "swaggertestsa"),
 *                 Map.entry("sourceResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/SwaggerTestRg/providers/Microsoft.Storage/storageAccounts/swaggertestsa")
 *             ))
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("swaggertestvault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ProtectionContainer StorageContainer;Storage;SwaggerTestRg;swaggertestsa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}
 * ```
 */
public class ProtectionContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ProtectionContainer,
) : KotlinCustomResource(javaResource, ProtectionContainerMapper) {
    /**
     * Optional ETag.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ProtectionContainerResource properties
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProtectionContainerMapper : ResourceMapper<ProtectionContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ProtectionContainer::class == javaResource::class

    override fun map(javaResource: Resource): ProtectionContainer = ProtectionContainer(
        javaResource
            as com.pulumi.azurenative.recoveryservices.ProtectionContainer,
    )
}

/**
 * @see [ProtectionContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProtectionContainer].
 */
public suspend fun protectionContainer(
    name: String,
    block: suspend ProtectionContainerResourceBuilder.() -> Unit,
): ProtectionContainer {
    val builder = ProtectionContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProtectionContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protectionContainer(name: String): ProtectionContainer {
    val builder = ProtectionContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
