@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ProtectionIntent].
 */
@PulumiTagMarker
public class ProtectionIntentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectionIntentArgs = ProtectionIntentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectionIntentArgsBuilder.() -> Unit) {
        val builder = ProtectionIntentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProtectionIntent {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ProtectionIntent(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProtectionIntent(builtJavaResource)
    }
}

/**
 * Base class for backup ProtectionIntent.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-06-01, 2023-08-01.
 * ## Example Usage
 * ### Create or Update Azure Vm Protection Intent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionIntent = new AzureNative.RecoveryServices.ProtectionIntent("protectionIntent", new()
 *     {
 *         FabricName = "Azure",
 *         IntentObjectName = "vm;iaasvmcontainerv2;chamsrgtest;chamscandel",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureResourceProtectionIntentArgs
 *         {
 *             PolicyId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myRG/providers/Microsoft.RecoveryServices/vaults/myVault/backupPolicies/myPolicy",
 *             ProtectionIntentItemType = "AzureResourceItem",
 *             SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/chamsrgtest/providers/Microsoft.Compute/virtualMachines/chamscandel",
 *         },
 *         ResourceGroupName = "myRG",
 *         VaultName = "myVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionIntent(ctx, "protectionIntent", &recoveryservices.ProtectionIntentArgs{
 * 			FabricName:       pulumi.String("Azure"),
 * 			IntentObjectName: pulumi.String("vm;iaasvmcontainerv2;chamsrgtest;chamscandel"),
 * 			Properties: recoveryservices.AzureResourceProtectionIntent{
 * 				PolicyId:                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myRG/providers/Microsoft.RecoveryServices/vaults/myVault/backupPolicies/myPolicy",
 * 				ProtectionIntentItemType: "AzureResourceItem",
 * 				SourceResourceId:         "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/chamsrgtest/providers/Microsoft.Compute/virtualMachines/chamscandel",
 * 			},
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			VaultName:         pulumi.String("myVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionIntent;
 * import com.pulumi.azurenative.recoveryservices.ProtectionIntentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionIntent = new ProtectionIntent("protectionIntent", ProtectionIntentArgs.builder()
 *             .fabricName("Azure")
 *             .intentObjectName("vm;iaasvmcontainerv2;chamsrgtest;chamscandel")
 *             .properties(Map.ofEntries(
 *                 Map.entry("policyId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myRG/providers/Microsoft.RecoveryServices/vaults/myVault/backupPolicies/myPolicy"),
 *                 Map.entry("protectionIntentItemType", "AzureResourceItem"),
 *                 Map.entry("sourceResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/chamsrgtest/providers/Microsoft.Compute/virtualMachines/chamscandel")
 *             ))
 *             .resourceGroupName("myRG")
 *             .vaultName("myVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ProtectionIntent vm;iaasvmcontainerv2;chamsrgtest;chamscandel /Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/backupProtectionIntent/{intentObjectName}
 * ```
 */
public class ProtectionIntent internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ProtectionIntent,
) : KotlinCustomResource(javaResource, ProtectionIntentMapper) {
    /**
     * Optional ETag.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ProtectionIntentResource properties
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProtectionIntentMapper : ResourceMapper<ProtectionIntent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ProtectionIntent::class == javaResource::class

    override fun map(javaResource: Resource): ProtectionIntent = ProtectionIntent(
        javaResource as
            com.pulumi.azurenative.recoveryservices.ProtectionIntent,
    )
}

/**
 * @see [ProtectionIntent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProtectionIntent].
 */
public suspend fun protectionIntent(
    name: String,
    block: suspend ProtectionIntentResourceBuilder.() -> Unit,
): ProtectionIntent {
    val builder = ProtectionIntentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProtectionIntent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protectionIntent(name: String): ProtectionIntent {
    val builder = ProtectionIntentResourceBuilder()
    builder.name(name)
    return builder.build()
}
