@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Base class for backup policy. Workload-specific backup policies are derived from this class.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2016-06-01, 2023-06-01, 2023-08-01.
 * ## Example Usage
 * ### Create or Update Daily Azure Storage Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "dailyPolicy2",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureFileShareProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureStorage",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 5,
 *                         DurationType = "Days",
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-09-29T08:00:00.000Z",
 *                     },
 *                 },
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 60,
 *                         DurationType = "Months",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-09-29T08:00:00.000Z",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 12,
 *                         DurationType = "Weeks",
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-09-29T08:00:00.000Z",
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.January,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 10,
 *                         DurationType = "Years",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-09-29T08:00:00.000Z",
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *             {
 *                 SchedulePolicyType = "SimpleSchedulePolicy",
 *                 ScheduleRunFrequency = "Daily",
 *                 ScheduleRunTimes = new[]
 *                 {
 *                     "2021-09-29T08:00:00.000Z",
 *                 },
 *             },
 *             TimeZone = "UTC",
 *             WorkLoadType = "AzureFileShare",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "swaggertestvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("dailyPolicy2"),
 * 			Properties: recoveryservices.AzureFileShareProtectionPolicy{
 * 				BackupManagementType: "AzureStorage",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        5,
 * 							DurationType: "Days",
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-09-29T08:00:00.000Z",
 * 						},
 * 					},
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        60,
 * 							DurationType: "Months",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-09-29T08:00:00.000Z",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekSunday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        12,
 * 							DurationType: "Weeks",
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-09-29T08:00:00.000Z",
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearJanuary,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        10,
 * 							DurationType: "Years",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-09-29T08:00:00.000Z",
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicy{
 * 					SchedulePolicyType:   "SimpleSchedulePolicy",
 * 					ScheduleRunFrequency: "Daily",
 * 					ScheduleRunTimes: []string{
 * 						"2021-09-29T08:00:00.000Z",
 * 					},
 * 				},
 * 				TimeZone:     "UTC",
 * 				WorkLoadType: "AzureFileShare",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("swaggertestvault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("dailyPolicy2")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backupManagementType", "AzureStorage"),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("dailySchedule", Map.ofEntries(
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 5),
 *                             Map.entry("durationType", "Days")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-09-29T08:00:00.000Z")
 *                     )),
 *                     Map.entry("monthlySchedule", Map.ofEntries(
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 60),
 *                             Map.entry("durationType", "Months")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek", "Sunday"),
 *                             Map.entry("weeksOfTheMonth", "First")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-09-29T08:00:00.000Z")
 *                     )),
 *                     Map.entry("retentionPolicyType", "LongTermRetentionPolicy"),
 *                     Map.entry("weeklySchedule", Map.ofEntries(
 *                         Map.entry("daysOfTheWeek", "Sunday"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 12),
 *                             Map.entry("durationType", "Weeks")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-09-29T08:00:00.000Z")
 *                     )),
 *                     Map.entry("yearlySchedule", Map.ofEntries(
 *                         Map.entry("monthsOfYear", "January"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 10),
 *                             Map.entry("durationType", "Years")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek", "Sunday"),
 *                             Map.entry("weeksOfTheMonth", "First")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-09-29T08:00:00.000Z")
 *                     ))
 *                 )),
 *                 Map.entry("schedulePolicy", Map.ofEntries(
 *                     Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                     Map.entry("scheduleRunFrequency", "Daily"),
 *                     Map.entry("scheduleRunTimes", "2021-09-29T08:00:00.000Z")
 *                 )),
 *                 Map.entry("timeZone", "UTC"),
 *                 Map.entry("workLoadType", "AzureFileShare")
 *             ))
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("swaggertestvault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Enhanced Azure Vm Protection Policy with Hourly backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "v2-daily-sample",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSVMProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureIaasVM",
 *             InstantRpRetentionRangeInDays = 30,
 *             PolicyType = "V2",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 180,
 *                         DurationType = "Days",
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 60,
 *                         DurationType = "Months",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 12,
 *                         DurationType = "Weeks",
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.January,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 10,
 *                         DurationType = "Years",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyV2Args
 *             {
 *                 HourlySchedule = new AzureNative.RecoveryServices.Inputs.HourlyScheduleArgs
 *                 {
 *                     Interval = 4,
 *                     ScheduleWindowDuration = 16,
 *                     ScheduleWindowStartTime = "2021-12-17T08:00:00Z",
 *                 },
 *                 SchedulePolicyType = "SimpleSchedulePolicyV2",
 *                 ScheduleRunFrequency = "Hourly",
 *             },
 *             TimeZone = "India Standard Time",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("v2-daily-sample"),
 * 			Properties: recoveryservices.AzureIaaSVMProtectionPolicy{
 * 				BackupManagementType:          "AzureIaasVM",
 * 				InstantRpRetentionRangeInDays: 30,
 * 				PolicyType:                    "V2",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        180,
 * 							DurationType: "Days",
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        60,
 * 							DurationType: "Months",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekSunday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        12,
 * 							DurationType: "Weeks",
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearJanuary,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        10,
 * 							DurationType: "Years",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicyV2{
 * 					HourlySchedule: recoveryservices.HourlySchedule{
 * 						Interval:                4,
 * 						ScheduleWindowDuration:  16,
 * 						ScheduleWindowStartTime: "2021-12-17T08:00:00Z",
 * 					},
 * 					SchedulePolicyType:   "SimpleSchedulePolicyV2",
 * 					ScheduleRunFrequency: "Hourly",
 * 				},
 * 				TimeZone: "India Standard Time",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("v2-daily-sample")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backupManagementType", "AzureIaasVM"),
 *                 Map.entry("instantRpRetentionRangeInDays", 30),
 *                 Map.entry("policyType", "V2"),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("dailySchedule", Map.ofEntries(
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 180),
 *                             Map.entry("durationType", "Days")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-12-17T08:00:00+00:00")
 *                     )),
 *                     Map.entry("monthlySchedule", Map.ofEntries(
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 60),
 *                             Map.entry("durationType", "Months")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek", "Sunday"),
 *                             Map.entry("weeksOfTheMonth", "First")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-12-17T08:00:00+00:00")
 *                     )),
 *                     Map.entry("retentionPolicyType", "LongTermRetentionPolicy"),
 *                     Map.entry("weeklySchedule", Map.ofEntries(
 *                         Map.entry("daysOfTheWeek", "Sunday"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 12),
 *                             Map.entry("durationType", "Weeks")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-12-17T08:00:00+00:00")
 *                     )),
 *                     Map.entry("yearlySchedule", Map.ofEntries(
 *                         Map.entry("monthsOfYear", "January"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 10),
 *                             Map.entry("durationType", "Years")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek", "Sunday"),
 *                             Map.entry("weeksOfTheMonth", "First")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-12-17T08:00:00+00:00")
 *                     ))
 *                 )),
 *                 Map.entry("schedulePolicy", Map.ofEntries(
 *                     Map.entry("hourlySchedule", Map.ofEntries(
 *                         Map.entry("interval", 4),
 *                         Map.entry("scheduleWindowDuration", 16),
 *                         Map.entry("scheduleWindowStartTime", "2021-12-17T08:00:00Z")
 *                     )),
 *                     Map.entry("schedulePolicyType", "SimpleSchedulePolicyV2"),
 *                     Map.entry("scheduleRunFrequency", "Hourly")
 *                 )),
 *                 Map.entry("timeZone", "India Standard Time")
 *             ))
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Enhanced Azure Vm Protection Policy with daily backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "v2-daily-sample",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSVMProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureIaasVM",
 *             InstantRpRetentionRangeInDays = 30,
 *             PolicyType = "V2",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 180,
 *                         DurationType = "Days",
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 60,
 *                         DurationType = "Months",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 12,
 *                         DurationType = "Weeks",
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.January,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 10,
 *                         DurationType = "Years",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyV2Args
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyScheduleArgs
 *                 {
 *                     ScheduleRunTimes = new[]
 *                     {
 *                         "2018-01-24T10:00:00Z",
 *                     },
 *                 },
 *                 SchedulePolicyType = "SimpleSchedulePolicyV2",
 *                 ScheduleRunFrequency = "Daily",
 *             },
 *             TimeZone = "India Standard Time",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("v2-daily-sample"),
 * 			Properties: recoveryservices.AzureIaaSVMProtectionPolicy{
 * 				BackupManagementType:          "AzureIaasVM",
 * 				InstantRpRetentionRangeInDays: 30,
 * 				PolicyType:                    "V2",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        180,
 * 							DurationType: "Days",
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        60,
 * 							DurationType: "Months",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekSunday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        12,
 * 							DurationType: "Weeks",
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearJanuary,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        10,
 * 							DurationType: "Years",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicyV2{
 * 					DailySchedule: recoveryservices.DailySchedule{
 * 						ScheduleRunTimes: []string{
 * 							"2018-01-24T10:00:00Z",
 * 						},
 * 					},
 * 					SchedulePolicyType:   "SimpleSchedulePolicyV2",
 * 					ScheduleRunFrequency: "Daily",
 * 				},
 * 				TimeZone: "India Standard Time",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("v2-daily-sample")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backupManagementType", "AzureIaasVM"),
 *                 Map.entry("instantRpRetentionRangeInDays", 30),
 *                 Map.entry("policyType", "V2"),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("dailySchedule", Map.ofEntries(
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 180),
 *                             Map.entry("durationType", "Days")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-12-17T08:00:00+00:00")
 *                     )),
 *                     Map.entry("monthlySchedule", Map.ofEntries(
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 60),
 *                             Map.entry("durationType", "Months")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek", "Sunday"),
 *                             Map.entry("weeksOfTheMonth", "First")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-12-17T08:00:00+00:00")
 *                     )),
 *                     Map.entry("retentionPolicyType", "LongTermRetentionPolicy"),
 *                     Map.entry("weeklySchedule", Map.ofEntries(
 *                         Map.entry("daysOfTheWeek", "Sunday"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 12),
 *                             Map.entry("durationType", "Weeks")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-12-17T08:00:00+00:00")
 *                     )),
 *                     Map.entry("yearlySchedule", Map.ofEntries(
 *                         Map.entry("monthsOfYear", "January"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 10),
 *                             Map.entry("durationType", "Years")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek", "Sunday"),
 *                             Map.entry("weeksOfTheMonth", "First")
 *                         )),
 *                         Map.entry("retentionTimes", "2021-12-17T08:00:00+00:00")
 *                     ))
 *                 )),
 *                 Map.entry("schedulePolicy", Map.ofEntries(
 *                     Map.entry("dailySchedule", Map.of("scheduleRunTimes", "2018-01-24T10:00:00Z")),
 *                     Map.entry("schedulePolicyType", "SimpleSchedulePolicyV2"),
 *                     Map.entry("scheduleRunFrequency", "Daily")
 *                 )),
 *                 Map.entry("timeZone", "India Standard Time")
 *             ))
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Full Azure Vm Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "testPolicy1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSVMProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureIaasVM",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 2,
 *                         DurationType = "Months",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Wednesday,
 *                             AzureNative.RecoveryServices.DayOfWeek.Thursday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                             AzureNative.RecoveryServices.WeekOfMonth.Third,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2018-01-24T10:00:00Z",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Monday,
 *                         AzureNative.RecoveryServices.DayOfWeek.Wednesday,
 *                         AzureNative.RecoveryServices.DayOfWeek.Thursday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 1,
 *                         DurationType = "Weeks",
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2018-01-24T10:00:00Z",
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.February,
 *                         AzureNative.RecoveryServices.MonthOfYear.November,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 4,
 *                         DurationType = "Years",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Monday,
 *                             AzureNative.RecoveryServices.DayOfWeek.Thursday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.Fourth,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2018-01-24T10:00:00Z",
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *             {
 *                 SchedulePolicyType = "SimpleSchedulePolicy",
 *                 ScheduleRunDays = new[]
 *                 {
 *                     AzureNative.RecoveryServices.DayOfWeek.Monday,
 *                     AzureNative.RecoveryServices.DayOfWeek.Wednesday,
 *                     AzureNative.RecoveryServices.DayOfWeek.Thursday,
 *                 },
 *                 ScheduleRunFrequency = "Weekly",
 *                 ScheduleRunTimes = new[]
 *                 {
 *                     "2018-01-24T10:00:00Z",
 *                 },
 *             },
 *             TimeZone = "Pacific Standard Time",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("testPolicy1"),
 * 			Properties: recoveryservices.AzureIaaSVMProtectionPolicy{
 * 				BackupManagementType: "AzureIaasVM",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        2,
 * 							DurationType: "Months",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekWednesday,
 * 								recoveryservices.DayOfWeekThursday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 								recoveryservices.WeekOfMonthThird,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2018-01-24T10:00:00Z",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekMonday,
 * 							recoveryservices.DayOfWeekWednesday,
 * 							recoveryservices.DayOfWeekThursday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        1,
 * 							DurationType: "Weeks",
 * 						},
 * 						RetentionTimes: []string{
 * 							"2018-01-24T10:00:00Z",
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearFebruary,
 * 							recoveryservices.MonthOfYearNovember,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        4,
 * 							DurationType: "Years",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekMonday,
 * 								recoveryservices.DayOfWeekThursday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFourth,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2018-01-24T10:00:00Z",
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicy{
 * 					SchedulePolicyType: "SimpleSchedulePolicy",
 * 					ScheduleRunDays: []recoveryservices.DayOfWeek{
 * 						recoveryservices.DayOfWeekMonday,
 * 						recoveryservices.DayOfWeekWednesday,
 * 						recoveryservices.DayOfWeekThursday,
 * 					},
 * 					ScheduleRunFrequency: "Weekly",
 * 					ScheduleRunTimes: []string{
 * 						"2018-01-24T10:00:00Z",
 * 					},
 * 				},
 * 				TimeZone: "Pacific Standard Time",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("testPolicy1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backupManagementType", "AzureIaasVM"),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("monthlySchedule", Map.ofEntries(
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 2),
 *                             Map.entry("durationType", "Months")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek",
 *                                 "Wednesday",
 *                                 "Thursday"),
 *                             Map.entry("weeksOfTheMonth",
 *                                 "First",
 *                                 "Third")
 *                         )),
 *                         Map.entry("retentionTimes", "2018-01-24T10:00:00Z")
 *                     )),
 *                     Map.entry("retentionPolicyType", "LongTermRetentionPolicy"),
 *                     Map.entry("weeklySchedule", Map.ofEntries(
 *                         Map.entry("daysOfTheWeek",
 *                             "Monday",
 *                             "Wednesday",
 *                             "Thursday"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 1),
 *                             Map.entry("durationType", "Weeks")
 *                         )),
 *                         Map.entry("retentionTimes", "2018-01-24T10:00:00Z")
 *                     )),
 *                     Map.entry("yearlySchedule", Map.ofEntries(
 *                         Map.entry("monthsOfYear",
 *                             "February",
 *                             "November"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 4),
 *                             Map.entry("durationType", "Years")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek",
 *                                 "Monday",
 *                                 "Thursday"),
 *                             Map.entry("weeksOfTheMonth", "Fourth")
 *                         )),
 *                         Map.entry("retentionTimes", "2018-01-24T10:00:00Z")
 *                     ))
 *                 )),
 *                 Map.entry("schedulePolicy", Map.ofEntries(
 *                     Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                     Map.entry("scheduleRunDays",
 *                         "Monday",
 *                         "Wednesday",
 *                         "Thursday"),
 *                     Map.entry("scheduleRunFrequency", "Weekly"),
 *                     Map.entry("scheduleRunTimes", "2018-01-24T10:00:00Z")
 *                 )),
 *                 Map.entry("timeZone", "Pacific Standard Time")
 *             ))
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Full Azure Workload Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "testPolicy1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureVmWorkloadProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureWorkload",
 *             Settings = new AzureNative.RecoveryServices.Inputs.SettingsArgs
 *             {
 *                 Issqlcompression = false,
 *                 TimeZone = "Pacific Standard Time",
 *             },
 *             SubProtectionPolicy = new[]
 *             {
 *                 new AzureNative.RecoveryServices.Inputs.SubProtectionPolicyArgs
 *                 {
 *                     PolicyType = "Full",
 *                     RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *                     {
 *                         MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                         {
 *                             RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 1,
 *                                 DurationType = "Months",
 *                             },
 *                             RetentionScheduleFormatType = "Weekly",
 *                             RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                             {
 *                                 DaysOfTheWeek = new[]
 *                                 {
 *                                     AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                                 },
 *                                 WeeksOfTheMonth = new[]
 *                                 {
 *                                     AzureNative.RecoveryServices.WeekOfMonth.Second,
 *                                 },
 *                             },
 *                             RetentionTimes = new[]
 *                             {
 *                                 "2018-01-24T10:00:00Z",
 *                             },
 *                         },
 *                         RetentionPolicyType = "LongTermRetentionPolicy",
 *                         WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                         {
 *                             DaysOfTheWeek = new[]
 *                             {
 *                                 AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                                 AzureNative.RecoveryServices.DayOfWeek.Tuesday,
 *                             },
 *                             RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 2,
 *                                 DurationType = "Weeks",
 *                             },
 *                             RetentionTimes = new[]
 *                             {
 *                                 "2018-01-24T10:00:00Z",
 *                             },
 *                         },
 *                         YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                         {
 *                             MonthsOfYear = new[]
 *                             {
 *                                 AzureNative.RecoveryServices.MonthOfYear.January,
 *                                 AzureNative.RecoveryServices.MonthOfYear.June,
 *                                 AzureNative.RecoveryServices.MonthOfYear.December,
 *                             },
 *                             RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 1,
 *                                 DurationType = "Years",
 *                             },
 *                             RetentionScheduleFormatType = "Weekly",
 *                             RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                             {
 *                                 DaysOfTheWeek = new[]
 *                                 {
 *                                     AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                                 },
 *                                 WeeksOfTheMonth = new[]
 *                                 {
 *                                     AzureNative.RecoveryServices.WeekOfMonth.Last,
 *                                 },
 *                             },
 *                             RetentionTimes = new[]
 *                             {
 *                                 "2018-01-24T10:00:00Z",
 *                             },
 *                         },
 *                     },
 *                     SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *                     {
 *                         SchedulePolicyType = "SimpleSchedulePolicy",
 *                         ScheduleRunDays = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                             AzureNative.RecoveryServices.DayOfWeek.Tuesday,
 *                         },
 *                         ScheduleRunFrequency = "Weekly",
 *                         ScheduleRunTimes = new[]
 *                         {
 *                             "2018-01-24T10:00:00Z",
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.RecoveryServices.Inputs.SubProtectionPolicyArgs
 *                 {
 *                     PolicyType = "Differential",
 *                     RetentionPolicy = new AzureNative.RecoveryServices.Inputs.SimpleRetentionPolicyArgs
 *                     {
 *                         RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 8,
 *                             DurationType = "Days",
 *                         },
 *                         RetentionPolicyType = "SimpleRetentionPolicy",
 *                     },
 *                     SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *                     {
 *                         SchedulePolicyType = "SimpleSchedulePolicy",
 *                         ScheduleRunDays = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Friday,
 *                         },
 *                         ScheduleRunFrequency = "Weekly",
 *                         ScheduleRunTimes = new[]
 *                         {
 *                             "2018-01-24T10:00:00Z",
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.RecoveryServices.Inputs.SubProtectionPolicyArgs
 *                 {
 *                     PolicyType = "Log",
 *                     RetentionPolicy = new AzureNative.RecoveryServices.Inputs.SimpleRetentionPolicyArgs
 *                     {
 *                         RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 7,
 *                             DurationType = "Days",
 *                         },
 *                         RetentionPolicyType = "SimpleRetentionPolicy",
 *                     },
 *                     SchedulePolicy = new AzureNative.RecoveryServices.Inputs.LogSchedulePolicyArgs
 *                     {
 *                         ScheduleFrequencyInMins = 60,
 *                         SchedulePolicyType = "LogSchedulePolicy",
 *                     },
 *                 },
 *             },
 *             WorkLoadType = "SQLDataBase",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("testPolicy1"),
 * 			Properties: recoveryservices.AzureVmWorkloadProtectionPolicy{
 * 				BackupManagementType: "AzureWorkload",
 * 				Settings: recoveryservices.Settings{
 * 					Issqlcompression: false,
 * 					TimeZone:         "Pacific Standard Time",
 * 				},
 * 				SubProtectionPolicy: []recoveryservices.SubProtectionPolicy{
 * 					{
 * 						PolicyType: "Full",
 * 						RetentionPolicy: {
 * 							MonthlySchedule: {
 * 								RetentionDuration: {
 * 									Count:        1,
 * 									DurationType: "Months",
 * 								},
 * 								RetentionScheduleFormatType: "Weekly",
 * 								RetentionScheduleWeekly: {
 * 									DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 										recoveryservices.DayOfWeekSunday,
 * 									},
 * 									WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 										recoveryservices.WeekOfMonthSecond,
 * 									},
 * 								},
 * 								RetentionTimes: []string{
 * 									"2018-01-24T10:00:00Z",
 * 								},
 * 							},
 * 							RetentionPolicyType: "LongTermRetentionPolicy",
 * 							WeeklySchedule: {
 * 								DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 									recoveryservices.DayOfWeekSunday,
 * 									recoveryservices.DayOfWeekTuesday,
 * 								},
 * 								RetentionDuration: {
 * 									Count:        2,
 * 									DurationType: "Weeks",
 * 								},
 * 								RetentionTimes: []string{
 * 									"2018-01-24T10:00:00Z",
 * 								},
 * 							},
 * 							YearlySchedule: {
 * 								MonthsOfYear: []recoveryservices.MonthOfYear{
 * 									recoveryservices.MonthOfYearJanuary,
 * 									recoveryservices.MonthOfYearJune,
 * 									recoveryservices.MonthOfYearDecember,
 * 								},
 * 								RetentionDuration: {
 * 									Count:        1,
 * 									DurationType: "Years",
 * 								},
 * 								RetentionScheduleFormatType: "Weekly",
 * 								RetentionScheduleWeekly: {
 * 									DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 										recoveryservices.DayOfWeekSunday,
 * 									},
 * 									WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 										recoveryservices.WeekOfMonthLast,
 * 									},
 * 								},
 * 								RetentionTimes: []string{
 * 									"2018-01-24T10:00:00Z",
 * 								},
 * 							},
 * 						},
 * 						SchedulePolicy: {
 * 							SchedulePolicyType: "SimpleSchedulePolicy",
 * 							ScheduleRunDays: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 								recoveryservices.DayOfWeekTuesday,
 * 							},
 * 							ScheduleRunFrequency: "Weekly",
 * 							ScheduleRunTimes: []string{
 * 								"2018-01-24T10:00:00Z",
 * 							},
 * 						},
 * 					},
 * 					{
 * 						PolicyType: "Differential",
 * 						RetentionPolicy: {
 * 							RetentionDuration: {
 * 								Count:        8,
 * 								DurationType: "Days",
 * 							},
 * 							RetentionPolicyType: "SimpleRetentionPolicy",
 * 						},
 * 						SchedulePolicy: {
 * 							SchedulePolicyType: "SimpleSchedulePolicy",
 * 							ScheduleRunDays: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekFriday,
 * 							},
 * 							ScheduleRunFrequency: "Weekly",
 * 							ScheduleRunTimes: []string{
 * 								"2018-01-24T10:00:00Z",
 * 							},
 * 						},
 * 					},
 * 					{
 * 						PolicyType: "Log",
 * 						RetentionPolicy: {
 * 							RetentionDuration: {
 * 								Count:        7,
 * 								DurationType: "Days",
 * 							},
 * 							RetentionPolicyType: "SimpleRetentionPolicy",
 * 						},
 * 						SchedulePolicy: {
 * 							ScheduleFrequencyInMins: 60,
 * 							SchedulePolicyType:      "LogSchedulePolicy",
 * 						},
 * 					},
 * 				},
 * 				WorkLoadType: "SQLDataBase",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("testPolicy1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backupManagementType", "AzureWorkload"),
 *                 Map.entry("settings", Map.ofEntries(
 *                     Map.entry("issqlcompression", false),
 *                     Map.entry("timeZone", "Pacific Standard Time")
 *                 )),
 *                 Map.entry("subProtectionPolicy",
 *                     Map.ofEntries(
 *                         Map.entry("policyType", "Full"),
 *                         Map.entry("retentionPolicy", Map.ofEntries(
 *                             Map.entry("monthlySchedule", Map.ofEntries(
 *                                 Map.entry("retentionDuration", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("durationType", "Months")
 *                                 )),
 *                                 Map.entry("retentionScheduleFormatType", "Weekly"),
 *                                 Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                                     Map.entry("daysOfTheWeek", "Sunday"),
 *                                     Map.entry("weeksOfTheMonth", "Second")
 *                                 )),
 *                                 Map.entry("retentionTimes", "2018-01-24T10:00:00Z")
 *                             )),
 *                             Map.entry("retentionPolicyType", "LongTermRetentionPolicy"),
 *                             Map.entry("weeklySchedule", Map.ofEntries(
 *                                 Map.entry("daysOfTheWeek",
 *                                     "Sunday",
 *                                     "Tuesday"),
 *                                 Map.entry("retentionDuration", Map.ofEntries(
 *                                     Map.entry("count", 2),
 *                                     Map.entry("durationType", "Weeks")
 *                                 )),
 *                                 Map.entry("retentionTimes", "2018-01-24T10:00:00Z")
 *                             )),
 *                             Map.entry("yearlySchedule", Map.ofEntries(
 *                                 Map.entry("monthsOfYear",
 *                                     "January",
 *                                     "June",
 *                                     "December"),
 *                                 Map.entry("retentionDuration", Map.ofEntries(
 *                                     Map.entry("count", 1),
 *                                     Map.entry("durationType", "Years")
 *                                 )),
 *                                 Map.entry("retentionScheduleFormatType", "Weekly"),
 *                                 Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                                     Map.entry("daysOfTheWeek", "Sunday"),
 *                                     Map.entry("weeksOfTheMonth", "Last")
 *                                 )),
 *                                 Map.entry("retentionTimes", "2018-01-24T10:00:00Z")
 *                             ))
 *                         )),
 *                         Map.entry("schedulePolicy", Map.ofEntries(
 *                             Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                             Map.entry("scheduleRunDays",
 *                                 "Sunday",
 *                                 "Tuesday"),
 *                             Map.entry("scheduleRunFrequency", "Weekly"),
 *                             Map.entry("scheduleRunTimes", "2018-01-24T10:00:00Z")
 *                         ))
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("policyType", "Differential"),
 *                         Map.entry("retentionPolicy", Map.ofEntries(
 *                             Map.entry("retentionDuration", Map.ofEntries(
 *                                 Map.entry("count", 8),
 *                                 Map.entry("durationType", "Days")
 *                             )),
 *                             Map.entry("retentionPolicyType", "SimpleRetentionPolicy")
 *                         )),
 *                         Map.entry("schedulePolicy", Map.ofEntries(
 *                             Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                             Map.entry("scheduleRunDays", "Friday"),
 *                             Map.entry("scheduleRunFrequency", "Weekly"),
 *                             Map.entry("scheduleRunTimes", "2018-01-24T10:00:00Z")
 *                         ))
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("policyType", "Log"),
 *                         Map.entry("retentionPolicy", Map.ofEntries(
 *                             Map.entry("retentionDuration", Map.ofEntries(
 *                                 Map.entry("count", 7),
 *                                 Map.entry("durationType", "Days")
 *                             )),
 *                             Map.entry("retentionPolicyType", "SimpleRetentionPolicy")
 *                         )),
 *                         Map.entry("schedulePolicy", Map.ofEntries(
 *                             Map.entry("scheduleFrequencyInMins", 60),
 *                             Map.entry("schedulePolicyType", "LogSchedulePolicy")
 *                         ))
 *                     )),
 *                 Map.entry("workLoadType", "SQLDataBase")
 *             ))
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Hourly Azure Storage Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "newPolicy2",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureFileShareProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureStorage",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 5,
 *                         DurationType = "Days",
 *                     },
 *                 },
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 60,
 *                         DurationType = "Months",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 12,
 *                         DurationType = "Weeks",
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.January,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 10,
 *                         DurationType = "Years",
 *                     },
 *                     RetentionScheduleFormatType = "Weekly",
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *             {
 *                 HourlySchedule = new AzureNative.RecoveryServices.Inputs.HourlyScheduleArgs
 *                 {
 *                     Interval = 4,
 *                     ScheduleWindowDuration = 12,
 *                     ScheduleWindowStartTime = "2021-09-29T08:00:00.000Z",
 *                 },
 *                 SchedulePolicyType = "SimpleSchedulePolicy",
 *                 ScheduleRunFrequency = "Hourly",
 *             },
 *             TimeZone = "UTC",
 *             WorkLoadType = "AzureFileShare",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "swaggertestvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("newPolicy2"),
 * 			Properties: recoveryservices.AzureFileShareProtectionPolicy{
 * 				BackupManagementType: "AzureStorage",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        5,
 * 							DurationType: "Days",
 * 						},
 * 					},
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        60,
 * 							DurationType: "Months",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekSunday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        12,
 * 							DurationType: "Weeks",
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearJanuary,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        10,
 * 							DurationType: "Years",
 * 						},
 * 						RetentionScheduleFormatType: "Weekly",
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicy{
 * 					HourlySchedule: recoveryservices.HourlySchedule{
 * 						Interval:                4,
 * 						ScheduleWindowDuration:  12,
 * 						ScheduleWindowStartTime: "2021-09-29T08:00:00.000Z",
 * 					},
 * 					SchedulePolicyType:   "SimpleSchedulePolicy",
 * 					ScheduleRunFrequency: "Hourly",
 * 				},
 * 				TimeZone:     "UTC",
 * 				WorkLoadType: "AzureFileShare",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("swaggertestvault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("newPolicy2")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backupManagementType", "AzureStorage"),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("dailySchedule", Map.of("retentionDuration", Map.ofEntries(
 *                         Map.entry("count", 5),
 *                         Map.entry("durationType", "Days")
 *                     ))),
 *                     Map.entry("monthlySchedule", Map.ofEntries(
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 60),
 *                             Map.entry("durationType", "Months")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek", "Sunday"),
 *                             Map.entry("weeksOfTheMonth", "First")
 *                         ))
 *                     )),
 *                     Map.entry("retentionPolicyType", "LongTermRetentionPolicy"),
 *                     Map.entry("weeklySchedule", Map.ofEntries(
 *                         Map.entry("daysOfTheWeek", "Sunday"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 12),
 *                             Map.entry("durationType", "Weeks")
 *                         ))
 *                     )),
 *                     Map.entry("yearlySchedule", Map.ofEntries(
 *                         Map.entry("monthsOfYear", "January"),
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 10),
 *                             Map.entry("durationType", "Years")
 *                         )),
 *                         Map.entry("retentionScheduleFormatType", "Weekly"),
 *                         Map.entry("retentionScheduleWeekly", Map.ofEntries(
 *                             Map.entry("daysOfTheWeek", "Sunday"),
 *                             Map.entry("weeksOfTheMonth", "First")
 *                         ))
 *                     ))
 *                 )),
 *                 Map.entry("schedulePolicy", Map.ofEntries(
 *                     Map.entry("hourlySchedule", Map.ofEntries(
 *                         Map.entry("interval", 4),
 *                         Map.entry("scheduleWindowDuration", 12),
 *                         Map.entry("scheduleWindowStartTime", "2021-09-29T08:00:00.000Z")
 *                     )),
 *                     Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                     Map.entry("scheduleRunFrequency", "Hourly")
 *                 )),
 *                 Map.entry("timeZone", "UTC"),
 *                 Map.entry("workLoadType", "AzureFileShare")
 *             ))
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("swaggertestvault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Simple Azure Vm Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "testPolicy1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSVMProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureIaasVM",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 1,
 *                         DurationType = "Days",
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2018-01-24T02:00:00Z",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *             {
 *                 SchedulePolicyType = "SimpleSchedulePolicy",
 *                 ScheduleRunFrequency = "Daily",
 *                 ScheduleRunTimes = new[]
 *                 {
 *                     "2018-01-24T02:00:00Z",
 *                 },
 *             },
 *             TimeZone = "Pacific Standard Time",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("testPolicy1"),
 * 			Properties: recoveryservices.AzureIaaSVMProtectionPolicy{
 * 				BackupManagementType: "AzureIaasVM",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        1,
 * 							DurationType: "Days",
 * 						},
 * 						RetentionTimes: []string{
 * 							"2018-01-24T02:00:00Z",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicy{
 * 					SchedulePolicyType:   "SimpleSchedulePolicy",
 * 					ScheduleRunFrequency: "Daily",
 * 					ScheduleRunTimes: []string{
 * 						"2018-01-24T02:00:00Z",
 * 					},
 * 				},
 * 				TimeZone: "Pacific Standard Time",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("testPolicy1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backupManagementType", "AzureIaasVM"),
 *                 Map.entry("retentionPolicy", Map.ofEntries(
 *                     Map.entry("dailySchedule", Map.ofEntries(
 *                         Map.entry("retentionDuration", Map.ofEntries(
 *                             Map.entry("count", 1),
 *                             Map.entry("durationType", "Days")
 *                         )),
 *                         Map.entry("retentionTimes", "2018-01-24T02:00:00Z")
 *                     )),
 *                     Map.entry("retentionPolicyType", "LongTermRetentionPolicy")
 *                 )),
 *                 Map.entry("schedulePolicy", Map.ofEntries(
 *                     Map.entry("schedulePolicyType", "SimpleSchedulePolicy"),
 *                     Map.entry("scheduleRunFrequency", "Daily"),
 *                     Map.entry("scheduleRunTimes", "2018-01-24T02:00:00Z")
 *                 )),
 *                 Map.entry("timeZone", "Pacific Standard Time")
 *             ))
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ProtectionPolicy testPolicy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupPolicies/{policyName}
 * ```
 * @property eTag Optional ETag.
 * @property location Resource location.
 * @property policyName Backup policy to be created.
 * @property properties ProtectionPolicyResource properties
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property tags Resource tags.
 * @property vaultName The name of the recovery services vault.
 */
public data class ProtectionPolicyArgs(
    public val eTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs =
        com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProtectionPolicyArgs].
 */
@PulumiTagMarker
public class ProtectionPolicyArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var location: Output<String>? = null

    private var policyName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Optional ETag.
     */
    @JvmName("aerpbryttmfbnygb")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qarmjrvexbmgtsfd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Backup policy to be created.
     */
    @JvmName("sckmvcdmuecjoweg")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value ProtectionPolicyResource properties
     */
    @JvmName("tfjqquvkuqwidqxt")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("koenemtwycqjfanm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("beafsncfyqkyefwj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("xmycxqcgvqangavr")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("sylqcukpnpkicitt")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hgceeyuebkrnluhl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Backup policy to be created.
     */
    @JvmName("fkumqrsywdgumuex")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value ProtectionPolicyResource properties
     */
    @JvmName("mhsphkmjgljejvgx")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("listsolqwebyimsp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xekpmrgadrbkhedj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xesqtvxcdsrusikq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("kudmtsaiqjtmitjf")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): ProtectionPolicyArgs = ProtectionPolicyArgs(
        eTag = eTag,
        location = location,
        policyName = policyName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
