@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.RecoveryPlanPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.RecoveryPlanPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationRecoveryPlan].
 */
@PulumiTagMarker
public class ReplicationRecoveryPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationRecoveryPlanArgs = ReplicationRecoveryPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationRecoveryPlanArgsBuilder.() -> Unit) {
        val builder = ReplicationRecoveryPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationRecoveryPlan {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlan(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationRecoveryPlan(builtJavaResource)
    }
}

/**
 * Recovery plan details.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01, 2023-08-01.
 * ## Example Usage
 * ### Creates a recovery plan with the given details.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationRecoveryPlan = new AzureNative.RecoveryServices.ReplicationRecoveryPlan("replicationRecoveryPlan", new()
 *     {
 *         Properties = new AzureNative.RecoveryServices.Inputs.CreateRecoveryPlanInputPropertiesArgs
 *         {
 *             FailoverDeploymentModel = "ResourceManager",
 *             Groups = new[]
 *             {
 *                 new AzureNative.RecoveryServices.Inputs.RecoveryPlanGroupArgs
 *                 {
 *                     EndGroupActions = new[] {},
 *                     GroupType = "Boot",
 *                     ReplicationProtectedItems = new[]
 *                     {
 *                         new AzureNative.RecoveryServices.Inputs.RecoveryPlanProtectedItemArgs
 *                         {
 *                             Id = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectedItems/f8491e4f-817a-40dd-a90c-af773978c75b",
 *                             VirtualMachineId = "f8491e4f-817a-40dd-a90c-af773978c75b",
 *                         },
 *                     },
 *                     StartGroupActions = new[] {},
 *                 },
 *             },
 *             PrimaryFabricId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1",
 *             RecoveryFabricId = "Microsoft Azure",
 *         },
 *         RecoveryPlanName = "RPtest1",
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationRecoveryPlan(ctx, "replicationRecoveryPlan", &recoveryservices.ReplicationRecoveryPlanArgs{
 * 			Properties: recoveryservices.RecoveryPlanPropertiesResponse{
 * 				FailoverDeploymentModel: pulumi.String("ResourceManager"),
 * 				Groups: []recoveryservices.RecoveryPlanGroupArgs{
 * 					{
 * 						EndGroupActions: recoveryservices.RecoveryPlanActionArray{},
 * 						GroupType:       pulumi.String("Boot"),
 * 						ReplicationProtectedItems: recoveryservices.RecoveryPlanProtectedItemArray{
 * 							{
 * 								Id:               pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectedItems/f8491e4f-817a-40dd-a90c-af773978c75b"),
 * 								VirtualMachineId: pulumi.String("f8491e4f-817a-40dd-a90c-af773978c75b"),
 * 							},
 * 						},
 * 						StartGroupActions: recoveryservices.RecoveryPlanActionArray{},
 * 					},
 * 				},
 * 				PrimaryFabricId:  pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1"),
 * 				RecoveryFabricId: pulumi.String("Microsoft Azure"),
 * 			},
 * 			RecoveryPlanName:  pulumi.String("RPtest1"),
 * 			ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * 			ResourceName:      pulumi.String("vault1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlan;
 * import com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationRecoveryPlan = new ReplicationRecoveryPlan("replicationRecoveryPlan", ReplicationRecoveryPlanArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("failoverDeploymentModel", "ResourceManager"),
 *                 Map.entry("groups", Map.ofEntries(
 *                     Map.entry("endGroupActions", ),
 *                     Map.entry("groupType", "Boot"),
 *                     Map.entry("replicationProtectedItems", Map.ofEntries(
 *                         Map.entry("id", "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectedItems/f8491e4f-817a-40dd-a90c-af773978c75b"),
 *                         Map.entry("virtualMachineId", "f8491e4f-817a-40dd-a90c-af773978c75b")
 *                     )),
 *                     Map.entry("startGroupActions", )
 *                 )),
 *                 Map.entry("primaryFabricId", "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1"),
 *                 Map.entry("recoveryFabricId", "Microsoft Azure")
 *             ))
 *             .recoveryPlanName("RPtest1")
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationRecoveryPlan RPtest1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}
 * ```
 */
public class ReplicationRecoveryPlan internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlan,
) : KotlinCustomResource(javaResource, ReplicationRecoveryPlanMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The custom details.
     */
    public val properties: Output<RecoveryPlanPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationRecoveryPlanMapper : ResourceMapper<ReplicationRecoveryPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlan::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationRecoveryPlan =
        ReplicationRecoveryPlan(
            javaResource as
                com.pulumi.azurenative.recoveryservices.ReplicationRecoveryPlan,
        )
}

/**
 * @see [ReplicationRecoveryPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationRecoveryPlan].
 */
public suspend fun replicationRecoveryPlan(
    name: String,
    block: suspend ReplicationRecoveryPlanResourceBuilder.() -> Unit,
): ReplicationRecoveryPlan {
    val builder = ReplicationRecoveryPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationRecoveryPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationRecoveryPlan(name: String): ReplicationRecoveryPlan {
    val builder = ReplicationRecoveryPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
