@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.StorageClassificationMappingPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.StorageClassificationMappingPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationStorageClassificationMapping].
 */
@PulumiTagMarker
public class ReplicationStorageClassificationMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationStorageClassificationMappingArgs =
        ReplicationStorageClassificationMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ReplicationStorageClassificationMappingArgsBuilder.() -> Unit) {
        val builder = ReplicationStorageClassificationMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationStorageClassificationMapping {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMapping(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationStorageClassificationMapping(builtJavaResource)
    }
}

/**
 * Storage mapping object.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01, 2023-08-01.
 * ## Example Usage
 * ### Create storage classification mapping.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationStorageClassificationMapping = new AzureNative.RecoveryServices.ReplicationStorageClassificationMapping("replicationStorageClassificationMapping", new()
 *     {
 *         FabricName = "2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0",
 *         Properties = new AzureNative.RecoveryServices.Inputs.StorageMappingInputPropertiesArgs
 *         {
 *             TargetStorageClassificationId = "/Subscriptions/9112a37f-0f3e-46ec-9c00-060c6edca071/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0/replicationStorageClassifications/8891569e-aaef-4a46-a4a0-78c14f2d7b09",
 *         },
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *         StorageClassificationMappingName = "testStorageMapping",
 *         StorageClassificationName = "8891569e-aaef-4a46-a4a0-78c14f2d7b09",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationStorageClassificationMapping(ctx, "replicationStorageClassificationMapping", &recoveryservices.ReplicationStorageClassificationMappingArgs{
 * 			FabricName: pulumi.String("2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0"),
 * 			Properties: &recoveryservices.StorageMappingInputPropertiesArgs{
 * 				TargetStorageClassificationId: pulumi.String("/Subscriptions/9112a37f-0f3e-46ec-9c00-060c6edca071/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0/replicationStorageClassifications/8891569e-aaef-4a46-a4a0-78c14f2d7b09"),
 * 			},
 * 			ResourceGroupName:                pulumi.String("resourceGroupPS1"),
 * 			ResourceName:                     pulumi.String("vault1"),
 * 			StorageClassificationMappingName: pulumi.String("testStorageMapping"),
 * 			StorageClassificationName:        pulumi.String("8891569e-aaef-4a46-a4a0-78c14f2d7b09"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMapping;
 * import com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationStorageClassificationMapping = new ReplicationStorageClassificationMapping("replicationStorageClassificationMapping", ReplicationStorageClassificationMappingArgs.builder()
 *             .fabricName("2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0")
 *             .properties(Map.of("targetStorageClassificationId", "/Subscriptions/9112a37f-0f3e-46ec-9c00-060c6edca071/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/2a48e3770ac08aa2be8bfbd94fcfb1cbf2dcc487b78fb9d3bd778304441b06a0/replicationStorageClassifications/8891569e-aaef-4a46-a4a0-78c14f2d7b09"))
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .storageClassificationMappingName("testStorageMapping")
 *             .storageClassificationName("8891569e-aaef-4a46-a4a0-78c14f2d7b09")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationStorageClassificationMapping testStorageMapping /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationStorageClassifications/{storageClassificationName}/replicationStorageClassificationMappings/{storageClassificationMappingName}
 * ```
 */
public class ReplicationStorageClassificationMapping internal constructor(
    override val javaResource:
    com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMapping,
) : KotlinCustomResource(javaResource, ReplicationStorageClassificationMappingMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the storage mapping object.
     */
    public val properties: Output<StorageClassificationMappingPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationStorageClassificationMappingMapper :
    ResourceMapper<ReplicationStorageClassificationMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMapping::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationStorageClassificationMapping =
        ReplicationStorageClassificationMapping(
            javaResource as
                com.pulumi.azurenative.recoveryservices.ReplicationStorageClassificationMapping,
        )
}

/**
 * @see [ReplicationStorageClassificationMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationStorageClassificationMapping].
 */
public suspend fun replicationStorageClassificationMapping(
    name: String,
    block: suspend ReplicationStorageClassificationMappingResourceBuilder.() -> Unit,
):
    ReplicationStorageClassificationMapping {
    val builder = ReplicationStorageClassificationMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationStorageClassificationMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationStorageClassificationMapping(name: String):
    ReplicationStorageClassificationMapping {
    val builder = ReplicationStorageClassificationMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
