@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.VCenterPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.VCenterPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationvCenter].
 */
@PulumiTagMarker
public class ReplicationvCenterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationvCenterArgs = ReplicationvCenterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationvCenterArgsBuilder.() -> Unit) {
        val builder = ReplicationvCenterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationvCenter {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationvCenter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationvCenter(builtJavaResource)
    }
}

/**
 * vCenter definition.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2021-03-01, 2023-06-01, 2023-08-01.
 * ## Example Usage
 * ### Add vCenter.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationvCenter = new AzureNative.RecoveryServices.ReplicationvCenter("replicationvCenter", new()
 *     {
 *         FabricName = "MadhaviFabric",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AddVCenterRequestPropertiesArgs
 *         {
 *             FriendlyName = "esx-78",
 *             IpAddress = "inmtest78",
 *             Port = "443",
 *             ProcessServerId = "5A720CAB-39CB-F445-BD1662B0B33164B5",
 *             RunAsAccountId = "2",
 *         },
 *         ResourceGroupName = "MadhaviVRG",
 *         ResourceName = "MadhaviVault",
 *         VcenterName = "esx-78",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationvCenter(ctx, "replicationvCenter", &recoveryservices.ReplicationvCenterArgs{
 * 			FabricName: pulumi.String("MadhaviFabric"),
 * 			Properties: &recoveryservices.AddVCenterRequestPropertiesArgs{
 * 				FriendlyName:    pulumi.String("esx-78"),
 * 				IpAddress:       pulumi.String("inmtest78"),
 * 				Port:            pulumi.String("443"),
 * 				ProcessServerId: pulumi.String("5A720CAB-39CB-F445-BD1662B0B33164B5"),
 * 				RunAsAccountId:  pulumi.String("2"),
 * 			},
 * 			ResourceGroupName: pulumi.String("MadhaviVRG"),
 * 			ResourceName:      pulumi.String("MadhaviVault"),
 * 			VcenterName:       pulumi.String("esx-78"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationvCenter;
 * import com.pulumi.azurenative.recoveryservices.ReplicationvCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationvCenter = new ReplicationvCenter("replicationvCenter", ReplicationvCenterArgs.builder()
 *             .fabricName("MadhaviFabric")
 *             .properties(Map.ofEntries(
 *                 Map.entry("friendlyName", "esx-78"),
 *                 Map.entry("ipAddress", "inmtest78"),
 *                 Map.entry("port", "443"),
 *                 Map.entry("processServerId", "5A720CAB-39CB-F445-BD1662B0B33164B5"),
 *                 Map.entry("runAsAccountId", "2")
 *             ))
 *             .resourceGroupName("MadhaviVRG")
 *             .resourceName("MadhaviVault")
 *             .vcenterName("esx-78")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationvCenter esx-78 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationvCenters/{vcenterName}
 * ```
 */
public class ReplicationvCenter internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ReplicationvCenter,
) : KotlinCustomResource(javaResource, ReplicationvCenterMapper) {
    /**
     * Resource Location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * VCenter related data.
     */
    public val properties: Output<VCenterPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationvCenterMapper : ResourceMapper<ReplicationvCenter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationvCenter::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationvCenter = ReplicationvCenter(
        javaResource as
            com.pulumi.azurenative.recoveryservices.ReplicationvCenter,
    )
}

/**
 * @see [ReplicationvCenter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationvCenter].
 */
public suspend fun replicationvCenter(
    name: String,
    block: suspend ReplicationvCenterResourceBuilder.() -> Unit,
): ReplicationvCenter {
    val builder = ReplicationvCenterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationvCenter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationvCenter(name: String): ReplicationvCenter {
    val builder = ReplicationvCenterResourceBuilder()
    builder.name(name)
    return builder.build()
}
