@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of backup items associated with this container.
 */
public enum class BackupItemType(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.BackupItemType,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.BackupItemType> {
    Invalid(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.Invalid),
    VM(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.VM),
    FileFolder(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.FileFolder),
    AzureSqlDb(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.AzureSqlDb),
    SQLDB(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.SQLDB),
    Exchange(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.Exchange),
    Sharepoint(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.Sharepoint),
    VMwareVM(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.VMwareVM),
    SystemState(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.SystemState),
    Client(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.Client),
    GenericDataSource(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.GenericDataSource),
    SQLDataBase(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.SQLDataBase),
    AzureFileShare(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.AzureFileShare),
    SAPHanaDatabase(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.SAPHanaDatabase),
    SAPAseDatabase(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.SAPAseDatabase),
    SAPHanaDBInstance(com.pulumi.azurenative.recoveryservices.enums.BackupItemType.SAPHanaDBInstance),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.BackupItemType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.BackupItemType):
            BackupItemType = BackupItemType.values().first { it.javaValue == javaType }
    }
}
