@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Backup state of this backup item.
 */
public enum class ProtectionStatus(
    public val javaValue: com.pulumi.azurenative.recoveryservices.enums.ProtectionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.enums.ProtectionStatus> {
    Invalid(com.pulumi.azurenative.recoveryservices.enums.ProtectionStatus.Invalid),
    NotProtected(com.pulumi.azurenative.recoveryservices.enums.ProtectionStatus.NotProtected),
    Protecting(com.pulumi.azurenative.recoveryservices.enums.ProtectionStatus.Protecting),
    Protected(com.pulumi.azurenative.recoveryservices.enums.ProtectionStatus.Protected),
    ProtectionFailed(com.pulumi.azurenative.recoveryservices.enums.ProtectionStatus.ProtectionFailed),
    ;

    override fun toJava(): com.pulumi.azurenative.recoveryservices.enums.ProtectionStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.enums.ProtectionStatus):
            ProtectionStatus = ProtectionStatus.values().first { it.javaValue == javaType }
    }
}
