@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2AEnableProtectionInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A2A enable protection input.
 * @property diskEncryptionInfo The recovery disk encryption information (for two pass flows).
 * @property fabricObjectId The fabric specific object Id of the virtual machine.
 * @property instanceType The class type.
 * Expected value is 'A2A'.
 * @property multiVmGroupId The multi vm group id.
 * @property multiVmGroupName The multi vm group name.
 * @property recoveryAvailabilitySetId The recovery availability set Id.
 * @property recoveryAvailabilityZone The recovery availability zone.
 * @property recoveryAzureNetworkId The recovery Azure virtual network ARM id.
 * @property recoveryBootDiagStorageAccountId The boot diagnostic storage account.
 * @property recoveryCapacityReservationGroupId The recovery capacity reservation group Id.
 * @property recoveryCloudServiceId The recovery cloud service Id. Valid for V1 scenarios.
 * @property recoveryContainerId The recovery container Id.
 * @property recoveryExtendedLocation The recovery extended location.
 * @property recoveryProximityPlacementGroupId The recovery proximity placement group Id.
 * @property recoveryResourceGroupId The recovery resource group Id. Valid for V2 scenarios.
 * @property recoverySubnetName The recovery subnet name.
 * @property recoveryVirtualMachineScaleSetId The virtual machine scale set Id.
 * @property vmDisks The list of vm disk details.
 * @property vmManagedDisks The list of vm managed disk details.
 */
public data class A2AEnableProtectionInputArgs(
    public val diskEncryptionInfo: Output<DiskEncryptionInfoArgs>? = null,
    public val fabricObjectId: Output<String>,
    public val instanceType: Output<String>,
    public val multiVmGroupId: Output<String>? = null,
    public val multiVmGroupName: Output<String>? = null,
    public val recoveryAvailabilitySetId: Output<String>? = null,
    public val recoveryAvailabilityZone: Output<String>? = null,
    public val recoveryAzureNetworkId: Output<String>? = null,
    public val recoveryBootDiagStorageAccountId: Output<String>? = null,
    public val recoveryCapacityReservationGroupId: Output<String>? = null,
    public val recoveryCloudServiceId: Output<String>? = null,
    public val recoveryContainerId: Output<String>? = null,
    public val recoveryExtendedLocation: Output<ExtendedLocationArgs>? = null,
    public val recoveryProximityPlacementGroupId: Output<String>? = null,
    public val recoveryResourceGroupId: Output<String>? = null,
    public val recoverySubnetName: Output<String>? = null,
    public val recoveryVirtualMachineScaleSetId: Output<String>? = null,
    public val vmDisks: Output<List<A2AVmDiskInputDetailsArgs>>? = null,
    public val vmManagedDisks: Output<List<A2AVmManagedDiskInputDetailsArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2AEnableProtectionInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.A2AEnableProtectionInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2AEnableProtectionInputArgs.builder()
            .diskEncryptionInfo(
                diskEncryptionInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .fabricObjectId(fabricObjectId.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .multiVmGroupId(multiVmGroupId?.applyValue({ args0 -> args0 }))
            .multiVmGroupName(multiVmGroupName?.applyValue({ args0 -> args0 }))
            .recoveryAvailabilitySetId(recoveryAvailabilitySetId?.applyValue({ args0 -> args0 }))
            .recoveryAvailabilityZone(recoveryAvailabilityZone?.applyValue({ args0 -> args0 }))
            .recoveryAzureNetworkId(recoveryAzureNetworkId?.applyValue({ args0 -> args0 }))
            .recoveryBootDiagStorageAccountId(recoveryBootDiagStorageAccountId?.applyValue({ args0 -> args0 }))
            .recoveryCapacityReservationGroupId(
                recoveryCapacityReservationGroupId?.applyValue({ args0 ->
                    args0
                }),
            )
            .recoveryCloudServiceId(recoveryCloudServiceId?.applyValue({ args0 -> args0 }))
            .recoveryContainerId(recoveryContainerId?.applyValue({ args0 -> args0 }))
            .recoveryExtendedLocation(
                recoveryExtendedLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .recoveryProximityPlacementGroupId(
                recoveryProximityPlacementGroupId?.applyValue({ args0 ->
                    args0
                }),
            )
            .recoveryResourceGroupId(recoveryResourceGroupId?.applyValue({ args0 -> args0 }))
            .recoverySubnetName(recoverySubnetName?.applyValue({ args0 -> args0 }))
            .recoveryVirtualMachineScaleSetId(recoveryVirtualMachineScaleSetId?.applyValue({ args0 -> args0 }))
            .vmDisks(
                vmDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vmManagedDisks(
                vmManagedDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [A2AEnableProtectionInputArgs].
 */
@PulumiTagMarker
public class A2AEnableProtectionInputArgsBuilder internal constructor() {
    private var diskEncryptionInfo: Output<DiskEncryptionInfoArgs>? = null

    private var fabricObjectId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var multiVmGroupId: Output<String>? = null

    private var multiVmGroupName: Output<String>? = null

    private var recoveryAvailabilitySetId: Output<String>? = null

    private var recoveryAvailabilityZone: Output<String>? = null

    private var recoveryAzureNetworkId: Output<String>? = null

    private var recoveryBootDiagStorageAccountId: Output<String>? = null

    private var recoveryCapacityReservationGroupId: Output<String>? = null

    private var recoveryCloudServiceId: Output<String>? = null

    private var recoveryContainerId: Output<String>? = null

    private var recoveryExtendedLocation: Output<ExtendedLocationArgs>? = null

    private var recoveryProximityPlacementGroupId: Output<String>? = null

    private var recoveryResourceGroupId: Output<String>? = null

    private var recoverySubnetName: Output<String>? = null

    private var recoveryVirtualMachineScaleSetId: Output<String>? = null

    private var vmDisks: Output<List<A2AVmDiskInputDetailsArgs>>? = null

    private var vmManagedDisks: Output<List<A2AVmManagedDiskInputDetailsArgs>>? = null

    /**
     * @param value The recovery disk encryption information (for two pass flows).
     */
    @JvmName("lvnilfdkfydialdt")
    public suspend fun diskEncryptionInfo(`value`: Output<DiskEncryptionInfoArgs>) {
        this.diskEncryptionInfo = value
    }

    /**
     * @param value The fabric specific object Id of the virtual machine.
     */
    @JvmName("yajegrbbegblgqol")
    public suspend fun fabricObjectId(`value`: Output<String>) {
        this.fabricObjectId = value
    }

    /**
     * @param value The class type.
     * Expected value is 'A2A'.
     */
    @JvmName("lanximbidevhlyyh")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The multi vm group id.
     */
    @JvmName("rgkqcmiiqgveolck")
    public suspend fun multiVmGroupId(`value`: Output<String>) {
        this.multiVmGroupId = value
    }

    /**
     * @param value The multi vm group name.
     */
    @JvmName("oqayyaabpvqfjdky")
    public suspend fun multiVmGroupName(`value`: Output<String>) {
        this.multiVmGroupName = value
    }

    /**
     * @param value The recovery availability set Id.
     */
    @JvmName("hxyhjknlhxuusyyo")
    public suspend fun recoveryAvailabilitySetId(`value`: Output<String>) {
        this.recoveryAvailabilitySetId = value
    }

    /**
     * @param value The recovery availability zone.
     */
    @JvmName("jucrjgnjhksfgosh")
    public suspend fun recoveryAvailabilityZone(`value`: Output<String>) {
        this.recoveryAvailabilityZone = value
    }

    /**
     * @param value The recovery Azure virtual network ARM id.
     */
    @JvmName("ubukltgsphnwoyym")
    public suspend fun recoveryAzureNetworkId(`value`: Output<String>) {
        this.recoveryAzureNetworkId = value
    }

    /**
     * @param value The boot diagnostic storage account.
     */
    @JvmName("mkxtbkostpdbqhpd")
    public suspend fun recoveryBootDiagStorageAccountId(`value`: Output<String>) {
        this.recoveryBootDiagStorageAccountId = value
    }

    /**
     * @param value The recovery capacity reservation group Id.
     */
    @JvmName("flqaarcqljrmcmth")
    public suspend fun recoveryCapacityReservationGroupId(`value`: Output<String>) {
        this.recoveryCapacityReservationGroupId = value
    }

    /**
     * @param value The recovery cloud service Id. Valid for V1 scenarios.
     */
    @JvmName("pqkhesxfkldnurjn")
    public suspend fun recoveryCloudServiceId(`value`: Output<String>) {
        this.recoveryCloudServiceId = value
    }

    /**
     * @param value The recovery container Id.
     */
    @JvmName("namrkqgyxaqfmdae")
    public suspend fun recoveryContainerId(`value`: Output<String>) {
        this.recoveryContainerId = value
    }

    /**
     * @param value The recovery extended location.
     */
    @JvmName("oojfbdwohxuinfbl")
    public suspend fun recoveryExtendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.recoveryExtendedLocation = value
    }

    /**
     * @param value The recovery proximity placement group Id.
     */
    @JvmName("vwykfciqiivjwvbr")
    public suspend fun recoveryProximityPlacementGroupId(`value`: Output<String>) {
        this.recoveryProximityPlacementGroupId = value
    }

    /**
     * @param value The recovery resource group Id. Valid for V2 scenarios.
     */
    @JvmName("pdqxeigpmcibpitf")
    public suspend fun recoveryResourceGroupId(`value`: Output<String>) {
        this.recoveryResourceGroupId = value
    }

    /**
     * @param value The recovery subnet name.
     */
    @JvmName("clbpvolhqibtfyeb")
    public suspend fun recoverySubnetName(`value`: Output<String>) {
        this.recoverySubnetName = value
    }

    /**
     * @param value The virtual machine scale set Id.
     */
    @JvmName("ffecfprcxtddtkpd")
    public suspend fun recoveryVirtualMachineScaleSetId(`value`: Output<String>) {
        this.recoveryVirtualMachineScaleSetId = value
    }

    /**
     * @param value The list of vm disk details.
     */
    @JvmName("qjorxhthivgyutbt")
    public suspend fun vmDisks(`value`: Output<List<A2AVmDiskInputDetailsArgs>>) {
        this.vmDisks = value
    }

    @JvmName("bdahgmincdyxgyoj")
    public suspend fun vmDisks(vararg values: Output<A2AVmDiskInputDetailsArgs>) {
        this.vmDisks = Output.all(values.asList())
    }

    /**
     * @param values The list of vm disk details.
     */
    @JvmName("vuyydwaiydngumgr")
    public suspend fun vmDisks(values: List<Output<A2AVmDiskInputDetailsArgs>>) {
        this.vmDisks = Output.all(values)
    }

    /**
     * @param value The list of vm managed disk details.
     */
    @JvmName("ycpmndrgqxcqylbg")
    public suspend fun vmManagedDisks(`value`: Output<List<A2AVmManagedDiskInputDetailsArgs>>) {
        this.vmManagedDisks = value
    }

    @JvmName("lyqqgkgoluxmrbgl")
    public suspend fun vmManagedDisks(vararg values: Output<A2AVmManagedDiskInputDetailsArgs>) {
        this.vmManagedDisks = Output.all(values.asList())
    }

    /**
     * @param values The list of vm managed disk details.
     */
    @JvmName("pcyulqrxuyairnip")
    public suspend fun vmManagedDisks(values: List<Output<A2AVmManagedDiskInputDetailsArgs>>) {
        this.vmManagedDisks = Output.all(values)
    }

    /**
     * @param value The recovery disk encryption information (for two pass flows).
     */
    @JvmName("cfatfykqdgjoixqp")
    public suspend fun diskEncryptionInfo(`value`: DiskEncryptionInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionInfo = mapped
    }

    /**
     * @param argument The recovery disk encryption information (for two pass flows).
     */
    @JvmName("woeffjgvwglrnfmu")
    public suspend
    fun diskEncryptionInfo(argument: suspend DiskEncryptionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionInfo = mapped
    }

    /**
     * @param value The fabric specific object Id of the virtual machine.
     */
    @JvmName("rlffulsmwikvfeil")
    public suspend fun fabricObjectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricObjectId = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'A2A'.
     */
    @JvmName("csmvxurtnybpjoak")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The multi vm group id.
     */
    @JvmName("aabaksttlcsuqmnm")
    public suspend fun multiVmGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiVmGroupId = mapped
    }

    /**
     * @param value The multi vm group name.
     */
    @JvmName("xotyrahgyoedwvtw")
    public suspend fun multiVmGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiVmGroupName = mapped
    }

    /**
     * @param value The recovery availability set Id.
     */
    @JvmName("lsaakwpqolrtccbx")
    public suspend fun recoveryAvailabilitySetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryAvailabilitySetId = mapped
    }

    /**
     * @param value The recovery availability zone.
     */
    @JvmName("wewisijughggcxxb")
    public suspend fun recoveryAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryAvailabilityZone = mapped
    }

    /**
     * @param value The recovery Azure virtual network ARM id.
     */
    @JvmName("dudlocfrmcsndjqw")
    public suspend fun recoveryAzureNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryAzureNetworkId = mapped
    }

    /**
     * @param value The boot diagnostic storage account.
     */
    @JvmName("hwdciakwtqmlkkay")
    public suspend fun recoveryBootDiagStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryBootDiagStorageAccountId = mapped
    }

    /**
     * @param value The recovery capacity reservation group Id.
     */
    @JvmName("ccceifdxhgxoomkp")
    public suspend fun recoveryCapacityReservationGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryCapacityReservationGroupId = mapped
    }

    /**
     * @param value The recovery cloud service Id. Valid for V1 scenarios.
     */
    @JvmName("odpigbeuycihhwst")
    public suspend fun recoveryCloudServiceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryCloudServiceId = mapped
    }

    /**
     * @param value The recovery container Id.
     */
    @JvmName("jlfysirsljvnhwmi")
    public suspend fun recoveryContainerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryContainerId = mapped
    }

    /**
     * @param value The recovery extended location.
     */
    @JvmName("tisghqqkkvaeuwwt")
    public suspend fun recoveryExtendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryExtendedLocation = mapped
    }

    /**
     * @param argument The recovery extended location.
     */
    @JvmName("wrtslsmbacwxaceb")
    public suspend
    fun recoveryExtendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recoveryExtendedLocation = mapped
    }

    /**
     * @param value The recovery proximity placement group Id.
     */
    @JvmName("rxnpdvwqjbulqbsf")
    public suspend fun recoveryProximityPlacementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryProximityPlacementGroupId = mapped
    }

    /**
     * @param value The recovery resource group Id. Valid for V2 scenarios.
     */
    @JvmName("rsjnbbygixbvoplj")
    public suspend fun recoveryResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryResourceGroupId = mapped
    }

    /**
     * @param value The recovery subnet name.
     */
    @JvmName("dklewgisnkbaqbjb")
    public suspend fun recoverySubnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoverySubnetName = mapped
    }

    /**
     * @param value The virtual machine scale set Id.
     */
    @JvmName("poymlvtpsdjupwuw")
    public suspend fun recoveryVirtualMachineScaleSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryVirtualMachineScaleSetId = mapped
    }

    /**
     * @param value The list of vm disk details.
     */
    @JvmName("ugqisxqbbnjljjxh")
    public suspend fun vmDisks(`value`: List<A2AVmDiskInputDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmDisks = mapped
    }

    /**
     * @param argument The list of vm disk details.
     */
    @JvmName("vibirbwyjsufnjhk")
    public suspend fun vmDisks(argument: List<suspend A2AVmDiskInputDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            A2AVmDiskInputDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vmDisks = mapped
    }

    /**
     * @param argument The list of vm disk details.
     */
    @JvmName("vovwmmbaqffdnext")
    public suspend fun vmDisks(vararg argument: suspend A2AVmDiskInputDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            A2AVmDiskInputDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vmDisks = mapped
    }

    /**
     * @param argument The list of vm disk details.
     */
    @JvmName("xfkrjxsheanjpcno")
    public suspend fun vmDisks(argument: suspend A2AVmDiskInputDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(A2AVmDiskInputDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vmDisks = mapped
    }

    /**
     * @param values The list of vm disk details.
     */
    @JvmName("uthklybxxuplcaha")
    public suspend fun vmDisks(vararg values: A2AVmDiskInputDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmDisks = mapped
    }

    /**
     * @param value The list of vm managed disk details.
     */
    @JvmName("oiifvtjsycxnerem")
    public suspend fun vmManagedDisks(`value`: List<A2AVmManagedDiskInputDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmManagedDisks = mapped
    }

    /**
     * @param argument The list of vm managed disk details.
     */
    @JvmName("ycylpitoeumetxyk")
    public suspend
    fun vmManagedDisks(argument: List<suspend A2AVmManagedDiskInputDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            A2AVmManagedDiskInputDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vmManagedDisks = mapped
    }

    /**
     * @param argument The list of vm managed disk details.
     */
    @JvmName("nryxrpjsbuikkxou")
    public suspend fun vmManagedDisks(
        vararg
        argument: suspend A2AVmManagedDiskInputDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            A2AVmManagedDiskInputDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vmManagedDisks = mapped
    }

    /**
     * @param argument The list of vm managed disk details.
     */
    @JvmName("wrlyylsngiogmotn")
    public suspend
    fun vmManagedDisks(argument: suspend A2AVmManagedDiskInputDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            A2AVmManagedDiskInputDetailsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vmManagedDisks = mapped
    }

    /**
     * @param values The list of vm managed disk details.
     */
    @JvmName("bdvjjgormhjgkikj")
    public suspend fun vmManagedDisks(vararg values: A2AVmManagedDiskInputDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmManagedDisks = mapped
    }

    internal fun build(): A2AEnableProtectionInputArgs = A2AEnableProtectionInputArgs(
        diskEncryptionInfo = diskEncryptionInfo,
        fabricObjectId = fabricObjectId ?: throw PulumiNullFieldException("fabricObjectId"),
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        multiVmGroupId = multiVmGroupId,
        multiVmGroupName = multiVmGroupName,
        recoveryAvailabilitySetId = recoveryAvailabilitySetId,
        recoveryAvailabilityZone = recoveryAvailabilityZone,
        recoveryAzureNetworkId = recoveryAzureNetworkId,
        recoveryBootDiagStorageAccountId = recoveryBootDiagStorageAccountId,
        recoveryCapacityReservationGroupId = recoveryCapacityReservationGroupId,
        recoveryCloudServiceId = recoveryCloudServiceId,
        recoveryContainerId = recoveryContainerId,
        recoveryExtendedLocation = recoveryExtendedLocation,
        recoveryProximityPlacementGroupId = recoveryProximityPlacementGroupId,
        recoveryResourceGroupId = recoveryResourceGroupId,
        recoverySubnetName = recoverySubnetName,
        recoveryVirtualMachineScaleSetId = recoveryVirtualMachineScaleSetId,
        vmDisks = vmDisks,
        vmManagedDisks = vmManagedDisks,
    )
}
