@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.A2AVmManagedDiskInputDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A2A managed disk input details.
 * @property diskEncryptionInfo The recovery disk encryption information (for one / single pass flows).
 * @property diskId The disk Id.
 * @property primaryStagingAzureStorageAccountId The primary staging storage account Arm Id.
 * @property recoveryDiskEncryptionSetId The recovery disk encryption set Id.
 * @property recoveryReplicaDiskAccountType The replica disk type. Its an optional value and will be same as source disk type if not user provided.
 * @property recoveryResourceGroupId The target resource group Arm Id.
 * @property recoveryTargetDiskAccountType The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
 */
public data class A2AVmManagedDiskInputDetailsArgs(
    public val diskEncryptionInfo: Output<DiskEncryptionInfoArgs>? = null,
    public val diskId: Output<String>,
    public val primaryStagingAzureStorageAccountId: Output<String>,
    public val recoveryDiskEncryptionSetId: Output<String>? = null,
    public val recoveryReplicaDiskAccountType: Output<String>? = null,
    public val recoveryResourceGroupId: Output<String>,
    public val recoveryTargetDiskAccountType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.A2AVmManagedDiskInputDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.A2AVmManagedDiskInputDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.A2AVmManagedDiskInputDetailsArgs.builder()
            .diskEncryptionInfo(
                diskEncryptionInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .diskId(diskId.applyValue({ args0 -> args0 }))
            .primaryStagingAzureStorageAccountId(
                primaryStagingAzureStorageAccountId.applyValue({ args0 ->
                    args0
                }),
            )
            .recoveryDiskEncryptionSetId(recoveryDiskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .recoveryReplicaDiskAccountType(recoveryReplicaDiskAccountType?.applyValue({ args0 -> args0 }))
            .recoveryResourceGroupId(recoveryResourceGroupId.applyValue({ args0 -> args0 }))
            .recoveryTargetDiskAccountType(
                recoveryTargetDiskAccountType?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [A2AVmManagedDiskInputDetailsArgs].
 */
@PulumiTagMarker
public class A2AVmManagedDiskInputDetailsArgsBuilder internal constructor() {
    private var diskEncryptionInfo: Output<DiskEncryptionInfoArgs>? = null

    private var diskId: Output<String>? = null

    private var primaryStagingAzureStorageAccountId: Output<String>? = null

    private var recoveryDiskEncryptionSetId: Output<String>? = null

    private var recoveryReplicaDiskAccountType: Output<String>? = null

    private var recoveryResourceGroupId: Output<String>? = null

    private var recoveryTargetDiskAccountType: Output<String>? = null

    /**
     * @param value The recovery disk encryption information (for one / single pass flows).
     */
    @JvmName("ifnesnvbksubcvix")
    public suspend fun diskEncryptionInfo(`value`: Output<DiskEncryptionInfoArgs>) {
        this.diskEncryptionInfo = value
    }

    /**
     * @param value The disk Id.
     */
    @JvmName("fcgrmvkqfqbktjbh")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The primary staging storage account Arm Id.
     */
    @JvmName("kyoywaburcuutipf")
    public suspend fun primaryStagingAzureStorageAccountId(`value`: Output<String>) {
        this.primaryStagingAzureStorageAccountId = value
    }

    /**
     * @param value The recovery disk encryption set Id.
     */
    @JvmName("licrfusenqhibarc")
    public suspend fun recoveryDiskEncryptionSetId(`value`: Output<String>) {
        this.recoveryDiskEncryptionSetId = value
    }

    /**
     * @param value The replica disk type. Its an optional value and will be same as source disk type if not user provided.
     */
    @JvmName("ofntgeuhpsxtuapg")
    public suspend fun recoveryReplicaDiskAccountType(`value`: Output<String>) {
        this.recoveryReplicaDiskAccountType = value
    }

    /**
     * @param value The target resource group Arm Id.
     */
    @JvmName("phgcddyjjcnnauro")
    public suspend fun recoveryResourceGroupId(`value`: Output<String>) {
        this.recoveryResourceGroupId = value
    }

    /**
     * @param value The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
     */
    @JvmName("axoeookojmdemunp")
    public suspend fun recoveryTargetDiskAccountType(`value`: Output<String>) {
        this.recoveryTargetDiskAccountType = value
    }

    /**
     * @param value The recovery disk encryption information (for one / single pass flows).
     */
    @JvmName("bqqcvpoxbewkmurs")
    public suspend fun diskEncryptionInfo(`value`: DiskEncryptionInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionInfo = mapped
    }

    /**
     * @param argument The recovery disk encryption information (for one / single pass flows).
     */
    @JvmName("qmcuymenwbeotuul")
    public suspend
    fun diskEncryptionInfo(argument: suspend DiskEncryptionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DiskEncryptionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionInfo = mapped
    }

    /**
     * @param value The disk Id.
     */
    @JvmName("lbmwnaudshacygye")
    public suspend fun diskId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The primary staging storage account Arm Id.
     */
    @JvmName("supleudjiftykxcr")
    public suspend fun primaryStagingAzureStorageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryStagingAzureStorageAccountId = mapped
    }

    /**
     * @param value The recovery disk encryption set Id.
     */
    @JvmName("ncgcvdthhpphvpnf")
    public suspend fun recoveryDiskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryDiskEncryptionSetId = mapped
    }

    /**
     * @param value The replica disk type. Its an optional value and will be same as source disk type if not user provided.
     */
    @JvmName("kcwunnumcbkftmup")
    public suspend fun recoveryReplicaDiskAccountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryReplicaDiskAccountType = mapped
    }

    /**
     * @param value The target resource group Arm Id.
     */
    @JvmName("skrjgkastrlfknkt")
    public suspend fun recoveryResourceGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryResourceGroupId = mapped
    }

    /**
     * @param value The target disk type after failover. Its an optional value and will be same as source disk type if not user provided.
     */
    @JvmName("msrsjtghuqtvfkta")
    public suspend fun recoveryTargetDiskAccountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryTargetDiskAccountType = mapped
    }

    internal fun build(): A2AVmManagedDiskInputDetailsArgs = A2AVmManagedDiskInputDetailsArgs(
        diskEncryptionInfo = diskEncryptionInfo,
        diskId = diskId ?: throw PulumiNullFieldException("diskId"),
        primaryStagingAzureStorageAccountId = primaryStagingAzureStorageAccountId ?: throw
            PulumiNullFieldException("primaryStagingAzureStorageAccountId"),
        recoveryDiskEncryptionSetId = recoveryDiskEncryptionSetId,
        recoveryReplicaDiskAccountType = recoveryReplicaDiskAccountType,
        recoveryResourceGroupId = recoveryResourceGroupId ?: throw
            PulumiNullFieldException("recoveryResourceGroupId"),
        recoveryTargetDiskAccountType = recoveryTargetDiskAccountType,
    )
}
