@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AddVCenterRequestPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of an add vCenter request.
 * @property friendlyName The friendly name of the vCenter.
 * @property ipAddress The IP address of the vCenter to be discovered.
 * @property port The port number for discovery.
 * @property processServerId The process server Id from where the discovery is orchestrated.
 * @property runAsAccountId The account Id which has privileges to discover the vCenter.
 */
public data class AddVCenterRequestPropertiesArgs(
    public val friendlyName: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val port: Output<String>? = null,
    public val processServerId: Output<String>? = null,
    public val runAsAccountId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AddVCenterRequestPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AddVCenterRequestPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AddVCenterRequestPropertiesArgs.builder()
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .processServerId(processServerId?.applyValue({ args0 -> args0 }))
            .runAsAccountId(runAsAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddVCenterRequestPropertiesArgs].
 */
@PulumiTagMarker
public class AddVCenterRequestPropertiesArgsBuilder internal constructor() {
    private var friendlyName: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var port: Output<String>? = null

    private var processServerId: Output<String>? = null

    private var runAsAccountId: Output<String>? = null

    /**
     * @param value The friendly name of the vCenter.
     */
    @JvmName("aqrmrwahaucvfsqb")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value The IP address of the vCenter to be discovered.
     */
    @JvmName("usupdhtjppetjfna")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value The port number for discovery.
     */
    @JvmName("oayotcmyoebupeih")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value The process server Id from where the discovery is orchestrated.
     */
    @JvmName("lkjhbuhgruqojytd")
    public suspend fun processServerId(`value`: Output<String>) {
        this.processServerId = value
    }

    /**
     * @param value The account Id which has privileges to discover the vCenter.
     */
    @JvmName("krgnrewwssqorxeh")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value The friendly name of the vCenter.
     */
    @JvmName("coxwqhasrttcloct")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value The IP address of the vCenter to be discovered.
     */
    @JvmName("vunncrwpgclfgqtp")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value The port number for discovery.
     */
    @JvmName("bhtbtjitshewcmdw")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The process server Id from where the discovery is orchestrated.
     */
    @JvmName("ouoonmxcmbljwieh")
    public suspend fun processServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processServerId = mapped
    }

    /**
     * @param value The account Id which has privileges to discover the vCenter.
     */
    @JvmName("hexiplawrcwkkwef")
    public suspend fun runAsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    internal fun build(): AddVCenterRequestPropertiesArgs = AddVCenterRequestPropertiesArgs(
        friendlyName = friendlyName,
        ipAddress = ipAddress,
        port = port,
        processServerId = processServerId,
        runAsAccountId = runAsAccountId,
    )
}
