@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureFileshareProtectedItemExtendedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional information about Azure File Share backup item.
 * @property oldestRecoveryPoint The oldest backup copy available for this item in the service.
 * @property policyState Indicates consistency of policy object and policy applied to this backup item.
 * @property recoveryPointCount Number of available backup copies associated with this backup item.
 */
public data class AzureFileshareProtectedItemExtendedInfoArgs(
    public val oldestRecoveryPoint: Output<String>? = null,
    public val policyState: Output<String>? = null,
    public val recoveryPointCount: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureFileshareProtectedItemExtendedInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureFileshareProtectedItemExtendedInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureFileshareProtectedItemExtendedInfoArgs.builder()
            .oldestRecoveryPoint(oldestRecoveryPoint?.applyValue({ args0 -> args0 }))
            .policyState(policyState?.applyValue({ args0 -> args0 }))
            .recoveryPointCount(recoveryPointCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileshareProtectedItemExtendedInfoArgs].
 */
@PulumiTagMarker
public class AzureFileshareProtectedItemExtendedInfoArgsBuilder internal constructor() {
    private var oldestRecoveryPoint: Output<String>? = null

    private var policyState: Output<String>? = null

    private var recoveryPointCount: Output<Int>? = null

    /**
     * @param value The oldest backup copy available for this item in the service.
     */
    @JvmName("odrqhnciwodvgsgd")
    public suspend fun oldestRecoveryPoint(`value`: Output<String>) {
        this.oldestRecoveryPoint = value
    }

    /**
     * @param value Indicates consistency of policy object and policy applied to this backup item.
     */
    @JvmName("vgxfctytybkuacis")
    public suspend fun policyState(`value`: Output<String>) {
        this.policyState = value
    }

    /**
     * @param value Number of available backup copies associated with this backup item.
     */
    @JvmName("rletvtplihkkwtyi")
    public suspend fun recoveryPointCount(`value`: Output<Int>) {
        this.recoveryPointCount = value
    }

    /**
     * @param value The oldest backup copy available for this item in the service.
     */
    @JvmName("hdyrxwqkpsjpudel")
    public suspend fun oldestRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oldestRecoveryPoint = mapped
    }

    /**
     * @param value Indicates consistency of policy object and policy applied to this backup item.
     */
    @JvmName("mhxduowfqccmsvls")
    public suspend fun policyState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyState = mapped
    }

    /**
     * @param value Number of available backup copies associated with this backup item.
     */
    @JvmName("niqruuwdtnjohgam")
    public suspend fun recoveryPointCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointCount = mapped
    }

    internal fun build(): AzureFileshareProtectedItemExtendedInfoArgs =
        AzureFileshareProtectedItemExtendedInfoArgs(
            oldestRecoveryPoint = oldestRecoveryPoint,
            policyState = policyState,
            recoveryPointCount = recoveryPointCount,
        )
}
