@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSVMProtectionPolicyArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.IAASVMPolicyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * IaaS VM workload-specific backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureIaasVM'.
 * @property instantRPDetails
 * @property instantRpRetentionRangeInDays Instant RP retention policy range in days
 * @property policyType
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property retentionPolicy Retention policy with the details on backup copy retention ranges.
 * @property schedulePolicy Backup schedule specified as part of backup policy.
 * @property tieringPolicy Tiering policy to automatically move RPs to another tier
 * Key is Target Tier, defined in RecoveryPointTierType enum.
 * Tiering policy specifies the criteria to move RP to the target tier.
 * @property timeZone TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
 */
public data class AzureIaaSVMProtectionPolicyArgs(
    public val backupManagementType: Output<String>,
    public val instantRPDetails: Output<InstantRPAdditionalDetailsArgs>? = null,
    public val instantRpRetentionRangeInDays: Output<Int>? = null,
    public val policyType: Output<Either<String, IAASVMPolicyType>>? = null,
    public val protectedItemsCount: Output<Int>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val retentionPolicy:
    Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>? = null,
    public val schedulePolicy: Output<Any>? = null,
    public val tieringPolicy: Output<Map<String, TieringPolicyArgs>>? = null,
    public val timeZone: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSVMProtectionPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSVMProtectionPolicyArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureIaaSVMProtectionPolicyArgs.builder()
            .backupManagementType(backupManagementType.applyValue({ args0 -> args0 }))
            .instantRPDetails(instantRPDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instantRpRetentionRangeInDays(instantRpRetentionRangeInDays?.applyValue({ args0 -> args0 }))
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protectedItemsCount(protectedItemsCount?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .retentionPolicy(
                retentionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .schedulePolicy(schedulePolicy?.applyValue({ args0 -> args0 }))
            .tieringPolicy(
                tieringPolicy?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureIaaSVMProtectionPolicyArgs].
 */
@PulumiTagMarker
public class AzureIaaSVMProtectionPolicyArgsBuilder internal constructor() {
    private var backupManagementType: Output<String>? = null

    private var instantRPDetails: Output<InstantRPAdditionalDetailsArgs>? = null

    private var instantRpRetentionRangeInDays: Output<Int>? = null

    private var policyType: Output<Either<String, IAASVMPolicyType>>? = null

    private var protectedItemsCount: Output<Int>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var retentionPolicy:
        Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>? = null

    private var schedulePolicy: Output<Any>? = null

    private var tieringPolicy: Output<Map<String, TieringPolicyArgs>>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureIaasVM'.
     */
    @JvmName("popsbyjojtckroil")
    public suspend fun backupManagementType(`value`: Output<String>) {
        this.backupManagementType = value
    }

    /**
     * @param value
     */
    @JvmName("dqnxuwdxgruxnapc")
    public suspend fun instantRPDetails(`value`: Output<InstantRPAdditionalDetailsArgs>) {
        this.instantRPDetails = value
    }

    /**
     * @param value Instant RP retention policy range in days
     */
    @JvmName("sqjqbaewooprjnae")
    public suspend fun instantRpRetentionRangeInDays(`value`: Output<Int>) {
        this.instantRpRetentionRangeInDays = value
    }

    /**
     * @param value
     */
    @JvmName("hkmdkgpyontjwnhp")
    public suspend fun policyType(`value`: Output<Either<String, IAASVMPolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("sxlworpanmuqcruk")
    public suspend fun protectedItemsCount(`value`: Output<Int>) {
        this.protectedItemsCount = value
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("dcfmuftpmyviwwew")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("lgbsgchxayevaaye")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("cybxveqmknstggsy")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("mqbmrtidrbqmghee")
    public suspend
    fun retentionPolicy(`value`: Output<Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>>) {
        this.retentionPolicy = value
    }

    /**
     * @param value Backup schedule specified as part of backup policy.
     */
    @JvmName("cubbsbndwwbfcdua")
    public suspend fun schedulePolicy(`value`: Output<Any>) {
        this.schedulePolicy = value
    }

    /**
     * @param value Tiering policy to automatically move RPs to another tier
     * Key is Target Tier, defined in RecoveryPointTierType enum.
     * Tiering policy specifies the criteria to move RP to the target tier.
     */
    @JvmName("lswfvpfkdiyafqcb")
    public suspend fun tieringPolicy(`value`: Output<Map<String, TieringPolicyArgs>>) {
        this.tieringPolicy = value
    }

    /**
     * @param value TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
     */
    @JvmName("lrimtysggvnatveb")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'AzureIaasVM'.
     */
    @JvmName("hjcxdddjquichdhi")
    public suspend fun backupManagementType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value
     */
    @JvmName("iqljqdwwfpvpqjpb")
    public suspend fun instantRPDetails(`value`: InstantRPAdditionalDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instantRPDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wprfovhboomyioyn")
    public suspend
    fun instantRPDetails(argument: suspend InstantRPAdditionalDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = InstantRPAdditionalDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.instantRPDetails = mapped
    }

    /**
     * @param value Instant RP retention policy range in days
     */
    @JvmName("wniuaqrdxwplobpt")
    public suspend fun instantRpRetentionRangeInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instantRpRetentionRangeInDays = mapped
    }

    /**
     * @param value
     */
    @JvmName("ixvhuofwdwkepwxc")
    public suspend fun policyType(`value`: Either<String, IAASVMPolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value
     */
    @JvmName("epcyvolffslofpiv")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IAASVMPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value
     */
    @JvmName("xaylcewcbrftfsuw")
    public fun policyType(`value`: IAASVMPolicyType) {
        val toBeMapped = Either.ofRight<String, IAASVMPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Number of items associated with this policy.
     */
    @JvmName("rdpktmrmyrdcnlvq")
    public suspend fun protectedItemsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemsCount = mapped
    }

    /**
     * @param value ResourceGuard Operation Requests
     */
    @JvmName("gpapqqvbscvhorln")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuard Operation Requests
     */
    @JvmName("vjaixdpppqbflvra")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("atvosdvdaygeknvy")
    public suspend
    fun retentionPolicy(`value`: Either<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("rqoyscdjdhxhxmsk")
    public fun retentionPolicy(`value`: LongTermRetentionPolicyArgs) {
        val toBeMapped = Either.ofLeft<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("jocbfamcrscxpnpm")
    public fun retentionPolicy(`value`: SimpleRetentionPolicyArgs) {
        val toBeMapped = Either.ofRight<LongTermRetentionPolicyArgs, SimpleRetentionPolicyArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Backup schedule specified as part of backup policy.
     */
    @JvmName("nxlqxjngbkfnsvvm")
    public suspend fun schedulePolicy(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulePolicy = mapped
    }

    /**
     * @param value Tiering policy to automatically move RPs to another tier
     * Key is Target Tier, defined in RecoveryPointTierType enum.
     * Tiering policy specifies the criteria to move RP to the target tier.
     */
    @JvmName("kayfvitfnosvdmgt")
    public suspend fun tieringPolicy(`value`: Map<String, TieringPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tieringPolicy = mapped
    }

    /**
     * @param argument Tiering policy to automatically move RPs to another tier
     * Key is Target Tier, defined in RecoveryPointTierType enum.
     * Tiering policy specifies the criteria to move RP to the target tier.
     */
    @JvmName("gsniovkgipxhgxky")
    public suspend fun tieringPolicy(
        vararg
        argument: Pair<String, suspend TieringPolicyArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                TieringPolicyArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.tieringPolicy = mapped
    }

    /**
     * @param values Tiering policy to automatically move RPs to another tier
     * Key is Target Tier, defined in RecoveryPointTierType enum.
     * Tiering policy specifies the criteria to move RP to the target tier.
     */
    @JvmName("kjblmfscdltoosud")
    public fun tieringPolicy(vararg values: Pair<String, TieringPolicyArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tieringPolicy = mapped
    }

    /**
     * @param value TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
     */
    @JvmName("flafocauxhfokyyj")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): AzureIaaSVMProtectionPolicyArgs = AzureIaaSVMProtectionPolicyArgs(
        backupManagementType = backupManagementType ?: throw
            PulumiNullFieldException("backupManagementType"),
        instantRPDetails = instantRPDetails,
        instantRpRetentionRangeInDays = instantRpRetentionRangeInDays,
        policyType = policyType,
        protectedItemsCount = protectedItemsCount,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        retentionPolicy = retentionPolicy,
        schedulePolicy = schedulePolicy,
        tieringPolicy = tieringPolicy,
        timeZone = timeZone,
    )
}
