@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureVMAppContainerProtectionContainerArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.BackupManagementType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.OperationType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.WorkloadType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Container for SQL workloads under Azure Virtual Machines.
 * @property backupManagementType Type of backup management for the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'VMAppContainer'.
 * @property extendedInfo Additional details of a workload container.
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property lastUpdatedTime Time stamp when this container was updated.
 * @property operationType Re-Do Operation
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 * @property sourceResourceId ARM ID of the virtual machine represented by this Azure Workload Container
 * @property workloadType Workload type for which registration was sent.
 */
public data class AzureVMAppContainerProtectionContainerArgs(
    public val backupManagementType: Output<Either<String, BackupManagementType>>? = null,
    public val containerType: Output<String>,
    public val extendedInfo: Output<AzureWorkloadContainerExtendedInfoArgs>? = null,
    public val friendlyName: Output<String>? = null,
    public val healthStatus: Output<String>? = null,
    public val lastUpdatedTime: Output<String>? = null,
    public val operationType: Output<Either<String, OperationType>>? = null,
    public val protectableObjectType: Output<String>? = null,
    public val registrationStatus: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val workloadType: Output<Either<String, WorkloadType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureVMAppContainerProtectionContainerArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.AzureVMAppContainerProtectionContainerArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureVMAppContainerProtectionContainerArgs.builder()
            .backupManagementType(
                backupManagementType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .containerType(containerType.applyValue({ args0 -> args0 }))
            .extendedInfo(extendedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .healthStatus(healthStatus?.applyValue({ args0 -> args0 }))
            .lastUpdatedTime(lastUpdatedTime?.applyValue({ args0 -> args0 }))
            .operationType(
                operationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protectableObjectType(protectableObjectType?.applyValue({ args0 -> args0 }))
            .registrationStatus(registrationStatus?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .workloadType(
                workloadType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureVMAppContainerProtectionContainerArgs].
 */
@PulumiTagMarker
public class AzureVMAppContainerProtectionContainerArgsBuilder internal constructor() {
    private var backupManagementType: Output<Either<String, BackupManagementType>>? = null

    private var containerType: Output<String>? = null

    private var extendedInfo: Output<AzureWorkloadContainerExtendedInfoArgs>? = null

    private var friendlyName: Output<String>? = null

    private var healthStatus: Output<String>? = null

    private var lastUpdatedTime: Output<String>? = null

    private var operationType: Output<Either<String, OperationType>>? = null

    private var protectableObjectType: Output<String>? = null

    private var registrationStatus: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    private var workloadType: Output<Either<String, WorkloadType>>? = null

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("xpcgrbawrdyqnmrt")
    public suspend fun backupManagementType(`value`: Output<Either<String, BackupManagementType>>) {
        this.backupManagementType = value
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'VMAppContainer'.
     */
    @JvmName("ytqcqjmjfehrnmtj")
    public suspend fun containerType(`value`: Output<String>) {
        this.containerType = value
    }

    /**
     * @param value Additional details of a workload container.
     */
    @JvmName("uurpjmbatvewfupx")
    public suspend fun extendedInfo(`value`: Output<AzureWorkloadContainerExtendedInfoArgs>) {
        this.extendedInfo = value
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("yjsraxmuvuwvcxyx")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("jrfonsibbnsrkdmb")
    public suspend fun healthStatus(`value`: Output<String>) {
        this.healthStatus = value
    }

    /**
     * @param value Time stamp when this container was updated.
     */
    @JvmName("pphdepddtfirtntp")
    public suspend fun lastUpdatedTime(`value`: Output<String>) {
        this.lastUpdatedTime = value
    }

    /**
     * @param value Re-Do Operation
     */
    @JvmName("hdvkgjtwaejdvsgb")
    public suspend fun operationType(`value`: Output<Either<String, OperationType>>) {
        this.operationType = value
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("oidhsbhnmklxqvkt")
    public suspend fun protectableObjectType(`value`: Output<String>) {
        this.protectableObjectType = value
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("rcbhplwovaqwvyqh")
    public suspend fun registrationStatus(`value`: Output<String>) {
        this.registrationStatus = value
    }

    /**
     * @param value ARM ID of the virtual machine represented by this Azure Workload Container
     */
    @JvmName("rynmrnpehbdvwwox")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Workload type for which registration was sent.
     */
    @JvmName("xscneomnplrxyehe")
    public suspend fun workloadType(`value`: Output<Either<String, WorkloadType>>) {
        this.workloadType = value
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("qslvwujjpdkhpmmo")
    public suspend fun backupManagementType(`value`: Either<String, BackupManagementType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("awgaguoqrgjgxple")
    public fun backupManagementType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("ayhlfqooylatwlwg")
    public fun backupManagementType(`value`: BackupManagementType) {
        val toBeMapped = Either.ofRight<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'VMAppContainer'.
     */
    @JvmName("xbwodkxdbqrgpcyv")
    public suspend fun containerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerType = mapped
    }

    /**
     * @param value Additional details of a workload container.
     */
    @JvmName("tbdcuslvlyvdbjkp")
    public suspend fun extendedInfo(`value`: AzureWorkloadContainerExtendedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedInfo = mapped
    }

    /**
     * @param argument Additional details of a workload container.
     */
    @JvmName("jxqwaqhcofehject")
    public suspend
    fun extendedInfo(argument: suspend AzureWorkloadContainerExtendedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AzureWorkloadContainerExtendedInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedInfo = mapped
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("rqguyvrlngadbnoi")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("oeoghpkansqlvhlb")
    public suspend fun healthStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthStatus = mapped
    }

    /**
     * @param value Time stamp when this container was updated.
     */
    @JvmName("ggpnvbgvpyvljaid")
    public suspend fun lastUpdatedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdatedTime = mapped
    }

    /**
     * @param value Re-Do Operation
     */
    @JvmName("kwixxwjdksnlwtuk")
    public suspend fun operationType(`value`: Either<String, OperationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value Re-Do Operation
     */
    @JvmName("nxoaedvboiuhllge")
    public fun operationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value Re-Do Operation
     */
    @JvmName("qjfmwidgelifbtmb")
    public fun operationType(`value`: OperationType) {
        val toBeMapped = Either.ofRight<String, OperationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("sqxnwikccaxgjsml")
    public suspend fun protectableObjectType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectableObjectType = mapped
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("raaqjoqfsmlmkcny")
    public suspend fun registrationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationStatus = mapped
    }

    /**
     * @param value ARM ID of the virtual machine represented by this Azure Workload Container
     */
    @JvmName("rxgcduliqiwvdmdy")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value Workload type for which registration was sent.
     */
    @JvmName("hbviawmtutgrgram")
    public suspend fun workloadType(`value`: Either<String, WorkloadType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadType = mapped
    }

    /**
     * @param value Workload type for which registration was sent.
     */
    @JvmName("boodggusracnbcui")
    public fun workloadType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadType = mapped
    }

    /**
     * @param value Workload type for which registration was sent.
     */
    @JvmName("dmoxmvcgvjasebjh")
    public fun workloadType(`value`: WorkloadType) {
        val toBeMapped = Either.ofRight<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadType = mapped
    }

    internal fun build(): AzureVMAppContainerProtectionContainerArgs =
        AzureVMAppContainerProtectionContainerArgs(
            backupManagementType = backupManagementType,
            containerType = containerType ?: throw PulumiNullFieldException("containerType"),
            extendedInfo = extendedInfo,
            friendlyName = friendlyName,
            healthStatus = healthStatus,
            lastUpdatedTime = lastUpdatedTime,
            operationType = operationType,
            protectableObjectType = protectableObjectType,
            registrationStatus = registrationStatus,
            sourceResourceId = sourceResourceId,
            workloadType = workloadType,
        )
}
