@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadContainerArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.BackupManagementType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.OperationType
import com.pulumi.azurenative.recoveryservices.kotlin.enums.WorkloadType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Container for the workloads running inside Azure Compute or Classic Compute.
 * @property backupManagementType Type of backup management for the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'AzureWorkloadContainer'.
 * @property extendedInfo Additional details of a workload container.
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property lastUpdatedTime Time stamp when this container was updated.
 * @property operationType Re-Do Operation
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 * @property sourceResourceId ARM ID of the virtual machine represented by this Azure Workload Container
 * @property workloadType Workload type for which registration was sent.
 */
public data class AzureWorkloadContainerArgs(
    public val backupManagementType: Output<Either<String, BackupManagementType>>? = null,
    public val containerType: Output<String>,
    public val extendedInfo: Output<AzureWorkloadContainerExtendedInfoArgs>? = null,
    public val friendlyName: Output<String>? = null,
    public val healthStatus: Output<String>? = null,
    public val lastUpdatedTime: Output<String>? = null,
    public val operationType: Output<Either<String, OperationType>>? = null,
    public val protectableObjectType: Output<String>? = null,
    public val registrationStatus: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val workloadType: Output<Either<String, WorkloadType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadContainerArgs =
        com.pulumi.azurenative.recoveryservices.inputs.AzureWorkloadContainerArgs.builder()
            .backupManagementType(
                backupManagementType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .containerType(containerType.applyValue({ args0 -> args0 }))
            .extendedInfo(extendedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .healthStatus(healthStatus?.applyValue({ args0 -> args0 }))
            .lastUpdatedTime(lastUpdatedTime?.applyValue({ args0 -> args0 }))
            .operationType(
                operationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .protectableObjectType(protectableObjectType?.applyValue({ args0 -> args0 }))
            .registrationStatus(registrationStatus?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .workloadType(
                workloadType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureWorkloadContainerArgs].
 */
@PulumiTagMarker
public class AzureWorkloadContainerArgsBuilder internal constructor() {
    private var backupManagementType: Output<Either<String, BackupManagementType>>? = null

    private var containerType: Output<String>? = null

    private var extendedInfo: Output<AzureWorkloadContainerExtendedInfoArgs>? = null

    private var friendlyName: Output<String>? = null

    private var healthStatus: Output<String>? = null

    private var lastUpdatedTime: Output<String>? = null

    private var operationType: Output<Either<String, OperationType>>? = null

    private var protectableObjectType: Output<String>? = null

    private var registrationStatus: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    private var workloadType: Output<Either<String, WorkloadType>>? = null

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("sgxjchgrfujahrlg")
    public suspend fun backupManagementType(`value`: Output<Either<String, BackupManagementType>>) {
        this.backupManagementType = value
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'AzureWorkloadContainer'.
     */
    @JvmName("xkugpcsycywhwqpj")
    public suspend fun containerType(`value`: Output<String>) {
        this.containerType = value
    }

    /**
     * @param value Additional details of a workload container.
     */
    @JvmName("khcgycwubtdikmjf")
    public suspend fun extendedInfo(`value`: Output<AzureWorkloadContainerExtendedInfoArgs>) {
        this.extendedInfo = value
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("uuraujljlgjltgvb")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("jqtbftqixqwqkkep")
    public suspend fun healthStatus(`value`: Output<String>) {
        this.healthStatus = value
    }

    /**
     * @param value Time stamp when this container was updated.
     */
    @JvmName("twxtjsvknemnwstn")
    public suspend fun lastUpdatedTime(`value`: Output<String>) {
        this.lastUpdatedTime = value
    }

    /**
     * @param value Re-Do Operation
     */
    @JvmName("wpdbindmtilaixjv")
    public suspend fun operationType(`value`: Output<Either<String, OperationType>>) {
        this.operationType = value
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("ulphducpyomfebbr")
    public suspend fun protectableObjectType(`value`: Output<String>) {
        this.protectableObjectType = value
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("vgipjkfqkjsfrwni")
    public suspend fun registrationStatus(`value`: Output<String>) {
        this.registrationStatus = value
    }

    /**
     * @param value ARM ID of the virtual machine represented by this Azure Workload Container
     */
    @JvmName("jfohhiwuvmlbmrwp")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Workload type for which registration was sent.
     */
    @JvmName("uwlrirnnajbfstwh")
    public suspend fun workloadType(`value`: Output<Either<String, WorkloadType>>) {
        this.workloadType = value
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("hjnnmmkuxcucdbep")
    public suspend fun backupManagementType(`value`: Either<String, BackupManagementType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("rsxppjudhveiwblw")
    public fun backupManagementType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of backup management for the container.
     */
    @JvmName("qmbyieykrfmirvkp")
    public fun backupManagementType(`value`: BackupManagementType) {
        val toBeMapped = Either.ofRight<String, BackupManagementType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupManagementType = mapped
    }

    /**
     * @param value Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
     * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
     * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
     * Backup is VMAppContainer
     * Expected value is 'AzureWorkloadContainer'.
     */
    @JvmName("alqbemblwttlxfmf")
    public suspend fun containerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerType = mapped
    }

    /**
     * @param value Additional details of a workload container.
     */
    @JvmName("wqkhvcpdngltlgqx")
    public suspend fun extendedInfo(`value`: AzureWorkloadContainerExtendedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedInfo = mapped
    }

    /**
     * @param argument Additional details of a workload container.
     */
    @JvmName("rvpgplsaoigvblmn")
    public suspend
    fun extendedInfo(argument: suspend AzureWorkloadContainerExtendedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AzureWorkloadContainerExtendedInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedInfo = mapped
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("ycoeeekkirborimu")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Status of health of the container.
     */
    @JvmName("mpormocknitnrovq")
    public suspend fun healthStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthStatus = mapped
    }

    /**
     * @param value Time stamp when this container was updated.
     */
    @JvmName("oijrkxmiicqwpucf")
    public suspend fun lastUpdatedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdatedTime = mapped
    }

    /**
     * @param value Re-Do Operation
     */
    @JvmName("gihrolkxiwshxwjg")
    public suspend fun operationType(`value`: Either<String, OperationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value Re-Do Operation
     */
    @JvmName("odbocvthxicvpaor")
    public fun operationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value Re-Do Operation
     */
    @JvmName("kobkjanlardpaqyn")
    public fun operationType(`value`: OperationType) {
        val toBeMapped = Either.ofRight<String, OperationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value Type of the protectable object associated with this container
     */
    @JvmName("okveujddikdmvkog")
    public suspend fun protectableObjectType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectableObjectType = mapped
    }

    /**
     * @param value Status of registration of the container with the Recovery Services Vault.
     */
    @JvmName("jcfmayosqevpbsrn")
    public suspend fun registrationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationStatus = mapped
    }

    /**
     * @param value ARM ID of the virtual machine represented by this Azure Workload Container
     */
    @JvmName("dksbsbhjnjvreogx")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value Workload type for which registration was sent.
     */
    @JvmName("nytxhxcwbhpunrnh")
    public suspend fun workloadType(`value`: Either<String, WorkloadType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadType = mapped
    }

    /**
     * @param value Workload type for which registration was sent.
     */
    @JvmName("ricbvwdxynyamexn")
    public fun workloadType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadType = mapped
    }

    /**
     * @param value Workload type for which registration was sent.
     */
    @JvmName("lkggirjiphybohlp")
    public fun workloadType(`value`: WorkloadType) {
        val toBeMapped = Either.ofRight<String, WorkloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadType = mapped
    }

    internal fun build(): AzureWorkloadContainerArgs = AzureWorkloadContainerArgs(
        backupManagementType = backupManagementType,
        containerType = containerType ?: throw PulumiNullFieldException("containerType"),
        extendedInfo = extendedInfo,
        friendlyName = friendlyName,
        healthStatus = healthStatus,
        lastUpdatedTime = lastUpdatedTime,
        operationType = operationType,
        protectableObjectType = protectableObjectType,
        registrationStatus = registrationStatus,
        sourceResourceId = sourceResourceId,
        workloadType = workloadType,
    )
}
