@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.CmkKekIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The details of the identity used for CMK
 * @property useSystemAssignedIdentity Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
 * @property userAssignedIdentity The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
 */
public data class CmkKekIdentityArgs(
    public val useSystemAssignedIdentity: Output<Boolean>? = null,
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.CmkKekIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.CmkKekIdentityArgs =
        com.pulumi.azurenative.recoveryservices.inputs.CmkKekIdentityArgs.builder()
            .useSystemAssignedIdentity(useSystemAssignedIdentity?.applyValue({ args0 -> args0 }))
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CmkKekIdentityArgs].
 */
@PulumiTagMarker
public class CmkKekIdentityArgsBuilder internal constructor() {
    private var useSystemAssignedIdentity: Output<Boolean>? = null

    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
     */
    @JvmName("yidisdbdtacmrcfq")
    public suspend fun useSystemAssignedIdentity(`value`: Output<Boolean>) {
        this.useSystemAssignedIdentity = value
    }

    /**
     * @param value The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
     */
    @JvmName("frvsgdoyirkaipwh")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
     */
    @JvmName("bqonalnkdslygseb")
    public suspend fun useSystemAssignedIdentity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSystemAssignedIdentity = mapped
    }

    /**
     * @param value The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
     */
    @JvmName("cswuyfkiwdpdhdjq")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): CmkKekIdentityArgs = CmkKekIdentityArgs(
        useSystemAssignedIdentity = useSystemAssignedIdentity,
        userAssignedIdentity = userAssignedIdentity,
    )
}
