@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.ContainerIdentityInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container identity information
 * @property aadTenantId Protection container identity - AAD Tenant
 * @property audience Protection container identity - Audience
 * @property servicePrincipalClientId Protection container identity - AAD Service Principal
 * @property uniqueName Unique name of the container
 */
public data class ContainerIdentityInfoArgs(
    public val aadTenantId: Output<String>? = null,
    public val audience: Output<String>? = null,
    public val servicePrincipalClientId: Output<String>? = null,
    public val uniqueName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.ContainerIdentityInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.ContainerIdentityInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.ContainerIdentityInfoArgs.builder()
            .aadTenantId(aadTenantId?.applyValue({ args0 -> args0 }))
            .audience(audience?.applyValue({ args0 -> args0 }))
            .servicePrincipalClientId(servicePrincipalClientId?.applyValue({ args0 -> args0 }))
            .uniqueName(uniqueName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerIdentityInfoArgs].
 */
@PulumiTagMarker
public class ContainerIdentityInfoArgsBuilder internal constructor() {
    private var aadTenantId: Output<String>? = null

    private var audience: Output<String>? = null

    private var servicePrincipalClientId: Output<String>? = null

    private var uniqueName: Output<String>? = null

    /**
     * @param value Protection container identity - AAD Tenant
     */
    @JvmName("fbcywdcaxnpgubwd")
    public suspend fun aadTenantId(`value`: Output<String>) {
        this.aadTenantId = value
    }

    /**
     * @param value Protection container identity - Audience
     */
    @JvmName("ayitjwonjectmdml")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value Protection container identity - AAD Service Principal
     */
    @JvmName("rtyfabvfsmtjhdeg")
    public suspend fun servicePrincipalClientId(`value`: Output<String>) {
        this.servicePrincipalClientId = value
    }

    /**
     * @param value Unique name of the container
     */
    @JvmName("nytokihnxaufopmr")
    public suspend fun uniqueName(`value`: Output<String>) {
        this.uniqueName = value
    }

    /**
     * @param value Protection container identity - AAD Tenant
     */
    @JvmName("uciiwralxewaulro")
    public suspend fun aadTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadTenantId = mapped
    }

    /**
     * @param value Protection container identity - Audience
     */
    @JvmName("cvrjsgxwpsxsdgei")
    public suspend fun audience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value Protection container identity - AAD Service Principal
     */
    @JvmName("ylyrawnhieohwlad")
    public suspend fun servicePrincipalClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalClientId = mapped
    }

    /**
     * @param value Unique name of the container
     */
    @JvmName("qeuhxketcgaaqwal")
    public suspend fun uniqueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueName = mapped
    }

    internal fun build(): ContainerIdentityInfoArgs = ContainerIdentityInfoArgs(
        aadTenantId = aadTenantId,
        audience = audience,
        servicePrincipalClientId = servicePrincipalClientId,
        uniqueName = uniqueName,
    )
}
